/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util.ftpfile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FileParser;

public class VMSFileParser
implements FileParser {
    private static final Logger log = Logger.getLogger(VMSFileParser.class);
    private Locale locale;
    private SimpleDateFormat formatter;
    private static final String[] formatString = new String[]{"dd-MMM-yyyy HH:mm:ss", "dd-MMM-yyyy HH:mm"};
    private String cacheLine = "";

    public VMSFileParser(Locale locale) {
        this.locale = locale;
    }

    public FTPFile parse(String serverString, String parentDirectory) throws ParseException {
        if (this.cacheLine.length() > 0) {
            serverString = this.cacheLine.concat(serverString);
            this.cacheLine = "";
        }
        if (serverString.length() == 0 || serverString.startsWith("Total") || serverString.startsWith("Directory")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(serverString, " ");
        if (st.countTokens() < 4) {
            this.cacheLine = serverString;
            return null;
        }
        String name = st.nextToken();
        if (name.lastIndexOf(";") <= 0 || !Character.isDigit(name.charAt(name.length() - 1))) {
            log.debug((Object)("Filename: " + name + " is not a valid filename"));
            throw new ParseException("Filename: " + name + " is not a valid filename", 0);
        }
        name = name.substring(0, name.lastIndexOf(";"));
        boolean directory = false;
        if (name.endsWith("DIR")) {
            directory = true;
            name = name.substring(0, name.indexOf("DIR") - 1);
        }
        long size = -1L;
        String sizeString = st.nextToken();
        if (sizeString.indexOf("/") > 0) {
            sizeString = sizeString.substring(0, sizeString.indexOf("/") - 1);
        }
        size = Long.parseLong(sizeString) * 512L * 1024L;
        Date date = null;
        String dateToken = st.nextToken();
        String timeToken = st.nextToken();
        boolean formatted = false;
        for (int i = 0; i < formatString.length; ++i) {
            try {
                this.formatter = new SimpleDateFormat(formatString[i], this.locale);
                date = this.formatter.parse(dateToken + " " + timeToken);
                formatted = true;
            }
            catch (ParseException pe) {
                try {
                    this.formatter = new SimpleDateFormat(formatString[i], Locale.ENGLISH);
                    date = this.formatter.parse(dateToken + " " + timeToken);
                    this.locale = Locale.ENGLISH;
                    formatted = true;
                }
                catch (ParseException pe2) {
                    formatted = false;
                }
            }
            if (formatted) break;
        }
        String groupOwner = st.nextToken();
        String group = null;
        String owner = null;
        if (groupOwner.indexOf(",") > 0) {
            group = groupOwner.substring(1, groupOwner.indexOf(","));
            owner = groupOwner.substring(groupOwner.indexOf(",") + 1, groupOwner.length() - 1);
        } else {
            group = groupOwner.substring(1, groupOwner.length() - 1);
        }
        String mode = st.nextToken();
        if (mode.startsWith("(") && mode.endsWith(")")) {
            mode = mode.substring(1, mode.length() - 1);
        }
        FTPFile file = new FTPFile(2, parentDirectory, name, serverString);
        file.setSize(size);
        file.setDirectory(directory);
        file.setDate(date);
        file.setGroup(group);
        file.setOwner(owner);
        file.setMode(mode);
        return file;
    }
}

