/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.firebirdsql.gds.impl.wire.AbstractJavaGDSImpl;

public class JavaGDSImpl
extends AbstractJavaGDSImpl {
    public Socket getSocket(String server, int port) throws IOException, UnknownHostException {
        byte[] address = this.parseRawAddress(server);
        if (address != null) {
            return new Socket(InetAddress.getByAddress(address), port);
        }
        return new Socket(server, port);
    }

    private byte[] parseRawAddress(String server) {
        byte[] address = null;
        String[] bytes = server.split(".");
        if (bytes.length == 4 || bytes.length == 16) {
            address = new byte[bytes.length];
            for (int index = 0; index < bytes.length; ++index) {
                int value = Integer.parseInt(bytes[index]);
                if (value <= 0 || value >= 255) {
                    return null;
                }
                address[index] = (byte)value;
            }
        }
        return address;
    }
}

