/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class Utils {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final DecimalFormat defaultNbrFormat = new DecimalFormat("0.00");

    public static String composeErrorMessage(String message, Exception cause) {
        String msg = "";
        if (StringUtils.isNotEmpty((String)message)) {
            msg = msg + message;
        }
        if (cause != null) {
            if (msg.length() > 0) {
                msg = msg + NEWLINE;
            }
            msg = msg + cause.getMessage();
        }
        return msg;
    }

    public static void main(String[] args) {
        try {
            URI uri = new URI("http://127.0.0.1:8080/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("http://127.0.0.1:8080/pentaho");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho");
            System.out.println(uri.getPath());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String joinPath(String ... paths) {
        return StringUtils.defaultString((String)StringUtils.join((Object[])paths, (String)"/")).replaceAll("/+", "/");
    }

    public static String toFirstLowerCase(String text) {
        if (text == null) {
            return null;
        }
        return text.length() > 1 ? text.substring(0, 1).toLowerCase() + text.substring(1) : text.toLowerCase();
    }

    public static String toFirstUpperCase(String text) {
        if (text == null) {
            return null;
        }
        return text.length() > 1 ? text.substring(0, 1).toUpperCase() + text.substring(1) : text.toUpperCase();
    }

    public static String ellapsedSeconds(long start) {
        return defaultNbrFormat.format((double)(System.currentTimeMillis() - start) / 1000.0);
    }

    public static String sanitizeSlashesInPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        return ("/" + path).replaceAll("\\\\+", "/").replaceAll("/+", "/");
    }

    public static String getNodeText(String xpath, Node node) {
        return Utils.getNodeText(xpath, node, null);
    }

    public static String getNodeText(String xpath, Node node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        Node n = node.selectSingleNode(xpath);
        if (n == null) {
            return defaultValue;
        }
        return n.getText();
    }

    public static Document getDocFromFile(IBasicFile file, EntityResolver resolver) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        if (resolver != null) {
            reader.setEntityResolver(resolver);
        }
        return reader.read(file.getContents());
    }

    public static Document getDocument(InputStream input) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(input);
    }

    public static List<Element> selectNodes(Element elem, String xpath) {
        return elem.selectNodes(xpath);
    }

    public static List<Element> selectNodes(Document doc, String xpath) {
        return doc.selectNodes(xpath);
    }

    public static Document getDocFromFile(IReadAccess access, String filePath, EntityResolver resolver) throws DocumentException, IOException {
        return access != null && filePath != null ? Utils.getDocFromFile(access.fetchFile(filePath), resolver) : null;
    }

    public static IReadAccess getAppropriateReadAccess(String resource) {
        return Utils.getAppropriateReadAccess(resource, null);
    }

    public static IReadAccess getAppropriateReadAccess(String resource, String basePath) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        ICdeEnvironment environment = CdeEngine.getInstance().getEnvironment();
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String res = resource.toLowerCase().replaceFirst("/", "");
        if (res.startsWith(environment.getSystemDir() + "/")) {
            if ((res = res.replaceFirst(environment.getSystemDir() + "/", "")).startsWith(environment.getPluginId() + "/")) {
                return factory.getPluginSystemReader(basePath);
            }
            String pluginId = res.substring(0, res.indexOf("/"));
            return factory.getOtherPluginSystemReader(pluginId, basePath);
        }
        if (res.startsWith(environment.getPluginRepositoryDir() + "/")) {
            return factory.getPluginRepositoryReader(basePath);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(res)) {
            return factory.getPluginSystemReader(basePath);
        }
        return factory.getUserContentAccess(basePath);
    }

    public static IReadAccess getSystemReadAccess(String pluginId, String basePath) {
        ICdeEnvironment environment = CdeEngine.getInstance().getEnvironment();
        IContentAccessFactory factory = environment.getContentAccessFactory();
        if (StringUtils.isEmpty((String)pluginId)) {
            return factory.getPluginSystemReader(basePath);
        }
        return factory.getOtherPluginSystemReader(pluginId, basePath);
    }

    public static IRWAccess getSystemRWAccess(String pluginId, String basePath) {
        ICdeEnvironment environment = CdeEngine.getInstance().getEnvironment();
        IContentAccessFactory factory = environment.getContentAccessFactory();
        if (StringUtils.isEmpty((String)pluginId)) {
            return factory.getPluginSystemWriter(basePath);
        }
        return factory.getOtherPluginSystemWriter(pluginId, basePath);
    }

    public static IRWAccess getAppropriateWriteAccess(String resource) {
        return Utils.getAppropriateWriteAccess(resource, null);
    }

    public static IRWAccess getAppropriateWriteAccess(String resource, String basePath) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        ICdeEnvironment environment = CdeEngine.getInstance().getEnvironment();
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String res = resource.toLowerCase().replaceFirst("/", "");
        if (res.startsWith(environment.getSystemDir() + "/")) {
            if ((res = res.replaceFirst(environment.getSystemDir() + "/", "")).startsWith(environment.getPluginId() + "/")) {
                return factory.getPluginSystemWriter(basePath);
            }
            String pluginId = res.substring(0, res.indexOf("/"));
            return factory.getOtherPluginSystemWriter(pluginId, basePath);
        }
        if (res.startsWith(environment.getPluginRepositoryDir() + "/")) {
            return factory.getPluginRepositoryWriter(basePath);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(res)) {
            return factory.getPluginSystemWriter(basePath);
        }
        return factory.getUserContentAccess(basePath);
    }

    public static IBasicFile getFileViaAppropriateReadAccess(String resource) {
        return Utils.getFileViaAppropriateReadAccess(resource, null);
    }

    public static IBasicFile getFileViaAppropriateReadAccess(String resource, String basePath) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        ICdeEnvironment environment = CdeEngine.getInstance().getEnvironment();
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String res = StringUtils.strip((String)resource.toLowerCase(), (String)"/");
        if (res.startsWith(environment.getSystemDir() + "/")) {
            if ((res = StringUtils.strip((String)res, (String)(environment.getSystemDir() + "/"))).startsWith(environment.getPluginId() + "/")) {
                resource = resource.replaceFirst(environment.getSystemDir() + "/" + environment.getPluginId() + "/", "");
                return factory.getPluginSystemReader(basePath).fetchFile(resource);
            }
            String pluginId = res.substring(0, resource.indexOf("/"));
            resource = resource.replaceFirst(environment.getSystemDir() + "/" + pluginId + "/", "");
            return factory.getOtherPluginSystemReader(pluginId, basePath).fetchFile(resource);
        }
        if (res.startsWith(environment.getPluginRepositoryDir() + "/")) {
            resource = resource.replaceFirst(environment.getPluginRepositoryDir() + "/", "");
            return factory.getPluginRepositoryReader(basePath).fetchFile(resource);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(resource)) {
            return factory.getPluginSystemReader(basePath).fetchFile(resource);
        }
        if (factory.getUserContentAccess(basePath).fileExists(resource)) {
            return factory.getUserContentAccess(basePath).fetchFile(resource);
        }
        return null;
    }

    public static IReadAccess getSystemOrUserReadAccess(String filePath) {
        IUserContentAccess readAccess = null;
        if (filePath.startsWith("/" + CdeEnvironment.getSystemDir() + "/") && (filePath.endsWith(".wcdf") || filePath.endsWith(".cdfde"))) {
            readAccess = Utils.getSystemReadAccess(filePath.split("/")[2], null);
        } else if (CdeEnvironment.getUserContentAccess().hasAccess(filePath, FileAccess.EXECUTE)) {
            readAccess = CdeEnvironment.getUserContentAccess();
        }
        return readAccess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRWAccess getSystemOrUserRWAccess(String filePath) {
        IUserContentAccess rwAccess = null;
        if (filePath.startsWith("/" + CdeEnvironment.getSystemDir() + "/")) {
            if (filePath.endsWith(".wcdf")) return Utils.getSystemRWAccess(filePath.split("/")[2], null);
            if (filePath.endsWith(".cdfde")) {
                return Utils.getSystemRWAccess(filePath.split("/")[2], null);
            }
        }
        if (CdeEnvironment.getUserContentAccess().fileExists(filePath)) {
            if (!CdeEnvironment.getUserContentAccess().hasAccess(filePath, FileAccess.EXECUTE)) return null;
            return CdeEnvironment.getUserContentAccess();
        }
        if (!CdeEnvironment.getUserContentAccess().hasAccess("/" + FilenameUtils.getPath((String)filePath), FileAccess.EXECUTE)) return rwAccess;
        return CdeEnvironment.getUserContentAccess();
    }

    public static boolean isValidJsonArray(String jsonString) {
        try {
            JSONArray.fromObject((Object)jsonString);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static class PathResolutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1838386876452885975L;

        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

