/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render.layout;

import org.apache.commons.jxpath.JXPathContext;
import pt.webdetails.cdf.dd.render.layout.DivRender;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class ColumnRender
extends DivRender {
    private String renderType;

    public ColumnRender(JXPathContext context) {
        super(context);
        this.renderType = XPathUtils.getStringValue(context, "//rendererType");
    }

    @Override
    public void processProperties() {
        super.processProperties();
        this.addColSpan(this.getPropertyString("columnSpan"));
        this.getPropertyBag().addColClass("append-", this.getPropertyString("columnAppend"));
        this.getPropertyBag().addColClass("prepend-", this.getPropertyString("columnPrepend"));
        this.getPropertyBag().addColClass(".prepend-top", this.getPropertyBoolean("columnPrependTop"));
        this.getPropertyBag().addColClass(".append-bottom", this.getPropertyBoolean("columnAppendBottom"));
        this.getPropertyBag().addColClass("border", this.getPropertyBoolean("columnBorder"));
        this.getPropertyBag().addColClass("colborder", this.getPropertyBoolean("columnBigBorder"));
    }

    @Override
    public String renderStart() {
        String div = "<div ";
        if (this.lastColumn()) {
            this.getPropertyBag().addClass("last");
        }
        div = div + this.getPropertyBagString() + ">";
        return div;
    }

    protected boolean lastColumn() {
        String parentId = (String)this.getNode().getValue("parent");
        return (Boolean)this.getNode().getValue("not(following-sibling::*[parent='" + parentId + "'][type='LayoutColumn'])");
    }

    protected String getRenderType() {
        return this.renderType;
    }

    protected void addColSpan(String value) {
        String spanPrefix = this.getRenderType().equals("bootstrap") ? "col-md-" : "span-";
        this.getPropertyBag().addColClass(spanPrefix, value);
    }
}

