/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.render.RenderException;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.render.layout.Render;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class RenderLayout
extends Renderer {
    public RenderLayout(JXPathContext doc, CdfRunJsDashboardWriteContext context) {
        super(doc, context);
    }

    @Override
    public String render(String alias) throws Exception {
        try {
            Iterator rootRows = this.doc.iteratePointers("/layout/rows[parent='UnIqEiD']");
            StringBuffer layout = new StringBuffer();
            layout.append(NEWLINE + this.getIndent(2) + "<div class='container'>");
            Map<String, CdfRunJsDashboardWriteResult> widgetsByContainerId = this.getWidgets(alias);
            this.renderRows(this.doc, rootRows, widgetsByContainerId, alias, layout, 4);
            layout.append(NEWLINE + this.getIndent(2) + "</div>");
            return layout.toString();
        }
        catch (RenderException ex) {
            return ex.getMessage();
        }
    }

    private void renderRows(JXPathContext doc, Iterator<Pointer> nodeIterator, Map<String, CdfRunJsDashboardWriteResult> widgetsByContainerId, String alias, StringBuffer layout, int indent) throws Exception {
        while (nodeIterator.hasNext()) {
            Pointer pointer = nodeIterator.next();
            JXPathContext context = doc.getRelativeContext(pointer);
            String rowId = (String)context.getValue("id");
            String rowName = XPathUtils.getStringValue(context, "properties[name='name']/value");
            Render renderer = (Render)this.getRender(context);
            renderer.processProperties();
            renderer.aliasId(alias);
            layout.append(NEWLINE + this.getIndent(indent));
            layout.append(renderer.renderStart());
            if (widgetsByContainerId.containsKey(rowName)) {
                CdfRunJsDashboardWriteResult widgetResult = widgetsByContainerId.get(rowName);
                layout.append(widgetResult.getLayout());
            } else {
                this.renderRows(context, context.iteratePointers("/layout/rows[parent='" + rowId + "']"), widgetsByContainerId, alias, layout, indent + 2);
            }
            layout.append(NEWLINE + this.getIndent(indent));
            layout.append(renderer.renderClose());
        }
    }

    @Override
    protected String getRenderClassName(String type) {
        return "pt.webdetails.cdf.dd.render.layout." + type.replace("Layout", "") + "Render";
    }
}

