/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.MetaModelManager;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.Resource;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.DependenciesPackage;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;

public final class DependenciesManager {
    private static Log logger = LogFactory.getLog(DependenciesManager.class);
    private static final String INCLUDES_PROP = "editor.includes.properties";
    private static final String EXTRA_INCLUDES_PROP = "render.includes.properties";
    private static DependenciesManager manager;
    private final HashMap<String, DependenciesPackage> packages = new HashMap();

    private DependenciesManager() {
    }

    public static synchronized DependenciesManager getInstance() {
        if (manager == null) {
            manager = DependenciesManager.createDependencyManager(MetaModelManager.getInstance().getModel());
        }
        return manager;
    }

    public static synchronized void refresh() {
        manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependenciesManager createInstance() {
        DependenciesManager manager = new DependenciesManager();
        IUrlProvider urlProvider = CdeEngine.getEnv().getUrlProvider();
        IContentAccessFactory factory = CdeEnvironment.getContentAccessFactory();
        manager.registerPackage("CDF-CSS", DependenciesPackage.PackageType.CSS);
        manager.registerPackage("CDF", DependenciesPackage.PackageType.JS);
        manager.registerPackage("CDF-RAW", new DependenciesPackage("CDF-RAW", DependenciesPackage.PackageType.JS, factory, urlProvider));
        manager.registerPackage("CDFDD", DependenciesPackage.PackageType.JS);
        Properties props = new Properties();
        try {
            InputStream in = null;
            try {
                in = CdeEnvironment.getPluginSystemReader().getFileInputStream(INCLUDES_PROP);
                props.load(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            StaticSystemOrigin origin = new StaticSystemOrigin("");
            manager.registerPackage("scripts", DependenciesPackage.PackageType.JS);
            DependenciesPackage scripts = manager.getPackage("scripts");
            if (props.containsKey("scripts")) {
                for (String path : props.get("scripts").toString().split(",")) {
                    if (path.isEmpty()) continue;
                    scripts.registerFileDependency(path, null, (PathOrigin)origin, path);
                }
            }
            manager.registerPackage("styles", DependenciesPackage.PackageType.CSS);
            DependenciesPackage styles = manager.getPackage("styles");
            if (props.containsKey("styles")) {
                for (String path : props.get("styles").toString().split(",")) {
                    if (path.isEmpty()) continue;
                    styles.registerFileDependency(path, null, (PathOrigin)origin, path);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error attempting to read editor.includes.properties", (Throwable)e);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependenciesManager createDependencyManager(MetaModel metaModel) {
        PathOrigin origin;
        long start = System.currentTimeMillis();
        DependenciesManager depMgr = DependenciesManager.createInstance();
        DependenciesPackage componentScripts = depMgr.getPackage("CDF");
        DependenciesPackage componentSnippets = depMgr.getPackage("CDF-RAW");
        DependenciesPackage componentStyles = depMgr.getPackage("CDF-CSS");
        DependenciesPackage ddScripts = depMgr.getPackage("CDFDD");
        for (ComponentType compType : metaModel.getComponentTypes()) {
            for (Resource res : compType.getResources()) {
                Resource.Type resType = res.getType();
                if (resType == Resource.Type.RAW) {
                    try {
                        componentSnippets.registerRawDependency(res.getName(), res.getVersion(), res.getSource());
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Failed to register code fragment '" + res.getSource() + "'"));
                    }
                    continue;
                }
                DependenciesPackage pack = null;
                if (resType == Resource.Type.SCRIPT) {
                    String app = res.getApp();
                    if (StringUtils.isEmpty((String)app) || app.equals("CDF")) {
                        pack = componentScripts;
                    } else if (app.equals("CDFDD")) {
                        pack = ddScripts;
                    }
                } else if (resType == Resource.Type.STYLE) {
                    pack = componentStyles;
                }
                if (pack == null) continue;
                try {
                    pack.registerFileDependency(res.getName(), res.getVersion(), res.getOrigin(), res.getSource());
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to register dependency '" + res.getSource() + "'"));
                }
            }
            origin = compType.getOrigin();
            String srcImpl = compType.getImplementationPath();
            if (!StringUtils.isNotEmpty((String)srcImpl)) continue;
            try {
                componentScripts.registerFileDependency(compType.getName(), compType.getVersion(), origin, srcImpl);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to register dependency '" + srcImpl + "'"));
            }
        }
        Properties extraProps = new Properties();
        try {
            InputStream in = null;
            try {
                in = CdeEnvironment.getPluginSystemReader().getFileInputStream(EXTRA_INCLUDES_PROP);
                extraProps.load(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            origin = new StaticSystemOrigin("");
            DependenciesPackage scripts = depMgr.getPackage("CDF");
            if (extraProps.containsKey("scripts")) {
                for (String path : extraProps.get("scripts").toString().split(",")) {
                    if (path.isEmpty()) continue;
                    scripts.registerFileDependency(path, null, origin, path);
                }
            }
            DependenciesPackage styles = depMgr.getPackage("CDF-CSS");
            if (extraProps.containsKey("styles")) {
                for (String path : extraProps.get("styles").toString().split(",")) {
                    if (path.isEmpty()) continue;
                    styles.registerFileDependency(path, null, origin, path);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error attempting to read render.includes.properties", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Registered meta model dependencies in %ss", Utils.ellapsedSeconds(start)));
        }
        return depMgr;
    }

    public DependenciesPackage getPackage(String id) {
        return this.packages.get(id);
    }

    public boolean registerPackage(String id, DependenciesPackage pkg) {
        return this.packages.put(id, pkg) != null;
    }

    public boolean registerPackage(String id, DependenciesPackage.PackageType type) {
        IUrlProvider urlProvider = CdeEngine.getEnv().getUrlProvider();
        return this.registerPackage(id, new DependenciesPackage(id, type, CdeEnvironment.getContentAccessFactory(), urlProvider));
    }

    public static final class StdPackages {
        public static final String COMPONENT_DEF_SCRIPTS = "CDF";
        public static final String COMPONENT_STYLES = "CDF-CSS";
        public static final String COMPONENT_SNIPPETS = "CDF-RAW";
        public static final String CDFDD = "CDFDD";
        public static final String EDITOR_JS_INCLUDES = "scripts";
        public static final String EDITOR_CSS_INCLUDES = "styles";
    }
}

