/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pt.webdetails.cdf.dd.render.cda.CalculatedColumns;
import pt.webdetails.cdf.dd.render.cda.CdaElementRenderer;
import pt.webdetails.cdf.dd.render.cda.Columns;
import pt.webdetails.cdf.dd.render.cda.CompoundComponent;
import pt.webdetails.cdf.dd.render.cda.DataFile;
import pt.webdetails.cdf.dd.render.cda.Keys;
import pt.webdetails.cdf.dd.render.cda.Olap4jProperties;
import pt.webdetails.cdf.dd.render.cda.Output;
import pt.webdetails.cdf.dd.render.cda.Parameters;
import pt.webdetails.cdf.dd.render.cda.Variables;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;

public class CdaRenderer {
    private final JSON cdaDefinitions = this.getCdaDefinitions();
    private final JXPathContext doc;
    private static String CDA_ELEMENTS_JXPATH = "/datasources/rows[meta='CDA']";

    public CdaRenderer(String docJson) {
        this(JXPathContext.newContext((Object)JSONSerializer.toJSON((Object)docJson.replaceAll("^\n*", ""))));
    }

    public CdaRenderer(JXPathContext doc) {
        this.doc = doc;
    }

    public boolean isEmpty() {
        if (this.doc == null) {
            return true;
        }
        Pointer pointer = this.doc.getPointer(CDA_ELEMENTS_JXPATH);
        return pointer == null || pointer instanceof NullPointer;
    }

    public String render() throws Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document cdaFile = builder.newDocument();
        Element root = cdaFile.createElement("CDADescriptor");
        cdaFile.appendChild(root);
        Element connections = cdaFile.createElement("DataSources");
        root.appendChild(connections);
        Iterator pointers = this.doc.iteratePointers(CDA_ELEMENTS_JXPATH);
        while (pointers.hasNext()) {
            Element dataAccess;
            Pointer pointer = (Pointer)pointers.next();
            JXPathContext context = JXPathContext.newContext((Object)pointer.getNode());
            String connectionId = (String)context.getValue("properties/.[name='name']/value", String.class);
            try {
                Element conn = this.exportConnection(cdaFile, context, connectionId);
                connections.appendChild(conn);
            }
            catch (Exception e) {
                connectionId = null;
            }
            if ((dataAccess = this.exportDataAccess(cdaFile, context, connectionId)) == null) continue;
            root.appendChild(dataAccess);
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(cdaFile);
        StreamResult res = new StreamResult(new OutputStreamWriter((OutputStream)result, "UTF-8"));
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, res);
        return result.toString();
    }

    private Element exportConnection(Document doc, JXPathContext context, String id) throws Exception {
        JXPathContext cda = JXPathContext.newContext((Object)this.cdaDefinitions);
        String type = ((String)context.getValue("type", String.class)).replaceAll("Components(.*)", "$1");
        String conntype = (String)context.getValue("meta_conntype", String.class);
        if (conntype.isEmpty() || conntype.equals("null")) {
            throw new Exception("No connection here!");
        }
        JXPathContext conn = JXPathContext.newContext((Object)((JSONObject)cda.getValue(type + "/definition/connection", JSONObject.class)));
        Element connection = doc.createElement("Connection");
        connection.setAttribute("id", id);
        connection.setAttribute("type", conntype);
        Iterator params = conn.iteratePointers("*");
        while (params.hasNext()) {
            String value;
            Pointer pointer = (Pointer)params.next();
            String paramName = pointer.asPath().replaceAll(".*name='(.*?)'.*", "$1");
            String placement = ((String)conn.getValue(pointer.asPath() + "/placement", String.class)).toLowerCase();
            if (placement.equals("attrib")) {
                if (paramName.equals("id")) continue;
                value = (String)context.getValue("properties/.[name='" + paramName + "']/value", String.class);
                connection.setAttribute(paramName, value);
                continue;
            }
            if (paramName.equals("variables")) {
                Variables vars = new Variables();
                vars.setContext(context);
                this.renderProperty(vars, context, paramName, connection);
                continue;
            }
            if (paramName.matches("olap4j.*")) {
                this.renderProperty(new Olap4jProperties(paramName), context, paramName, connection);
                continue;
            }
            if (paramName.equals("dataFile")) {
                this.renderProperty(new DataFile(), context, paramName, connection);
                continue;
            }
            if (paramName.equals("property") && this.isValidJsonArray(context, paramName)) {
                JSONArray jsonArray = JSONArray.fromObject((Object)context.getValue("properties/.[name='" + paramName + "']/value"));
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONArray json = (JSONArray)jsonArray.get(i);
                    String name = json.getString(0);
                    String value2 = json.getString(1);
                    Element child = doc.createElement(Utils.toFirstUpperCase(paramName));
                    child.setAttribute("name", name);
                    child.appendChild(doc.createTextNode(value2));
                    connection.appendChild(child);
                }
                continue;
            }
            value = (String)context.getValue("properties/.[name='" + paramName + "']/value", String.class);
            Element child = doc.createElement(Utils.toFirstUpperCase(paramName));
            child.appendChild(doc.createTextNode(value));
            connection.appendChild(child);
        }
        return connection;
    }

    private void renderProperty(CdaElementRenderer renderer, JXPathContext context, String propertyName, Element element) {
        renderer.setDefinition((JSONObject)context.getValue("properties/.[name='" + propertyName + "']"));
        renderer.renderInto(element);
    }

    private Element exportDataAccess(Document doc, JXPathContext context, String connectionId) {
        String tagName = "DataAccess";
        JXPathContext cda = JXPathContext.newContext((Object)this.cdaDefinitions);
        String type = ((String)context.getValue("type", String.class)).replaceAll("Components(.*)", "$1");
        String daType = (String)context.getValue("meta_datype", String.class);
        if (type.equals("join") || type.equals("union")) {
            tagName = "CompoundDataAccess";
        }
        String name = (String)context.getValue("properties/.[name='name']/value", String.class);
        JXPathContext conn = JXPathContext.newContext((Object)((JSONObject)cda.getValue(type + "/definition/dataaccess", JSONObject.class)));
        Element dataAccess = doc.createElement(tagName);
        dataAccess.setAttribute("id", name);
        dataAccess.setAttribute("type", daType);
        if (connectionId != null && !connectionId.equals("")) {
            dataAccess.setAttribute("connection", connectionId);
        }
        Iterator params = conn.iteratePointers("*");
        while (params.hasNext()) {
            String value;
            Pointer pointer = (Pointer)params.next();
            String paramName = pointer.asPath().replaceAll(".*name='(.*?)'.*", "$1");
            String placement = ((String)conn.getValue(pointer.asPath() + "/placement", String.class)).toLowerCase();
            if (placement.equals("attrib")) {
                if (paramName.equals("id") || paramName.equals("connection")) continue;
                value = (String)context.getValue("properties/.[name='" + paramName + "']/value", String.class);
                dataAccess.setAttribute(paramName, value);
                continue;
            }
            if (paramName.equals("parameters")) {
                this.renderProperty(new Parameters(), context, paramName, dataAccess);
                continue;
            }
            if (paramName.equals("output")) {
                Output output = new Output();
                output.setContext(context);
                this.renderProperty(output, context, paramName, dataAccess);
                continue;
            }
            if (paramName.equals("variables")) {
                Variables vars = new Variables();
                vars.setContext(context);
                this.renderProperty(vars, context, paramName, dataAccess);
                continue;
            }
            if (paramName.equals("outputMode")) break;
            if (paramName.equals("columns")) {
                Element cols = dataAccess.getOwnerDocument().createElement("Columns");
                this.renderProperty(new Columns(), context, "cdacolumns", cols);
                this.renderProperty(new CalculatedColumns(), context, "cdacalculatedcolumns", cols);
                dataAccess.appendChild(cols);
                continue;
            }
            if (paramName.equals("top") || paramName.equals("bottom") || paramName.equals("left") || paramName.equals("right")) {
                Element compoundElem = dataAccess.getOwnerDocument().createElement(Utils.toFirstUpperCase(paramName));
                this.renderProperty(new CompoundComponent(), context, paramName, compoundElem);
                dataAccess.appendChild(compoundElem);
                if (paramName.equals("left")) {
                    this.renderProperty(new Keys(), context, "leftkeys", compoundElem);
                    continue;
                }
                if (!paramName.equals("right")) continue;
                this.renderProperty(new Keys(), context, "rightkeys", compoundElem);
                continue;
            }
            value = (String)context.getValue("properties/.[name='" + paramName + "']/value", String.class);
            if (paramName.equals("query")) {
                value = value.trim();
            }
            Element child = doc.createElement(Utils.toFirstUpperCase(paramName));
            child.appendChild(doc.createTextNode(value));
            dataAccess.appendChild(child);
        }
        return dataAccess;
    }

    public JSON getCdaDefinitions() {
        return CdeEnvironment.getDataSourceManager().getProviderJsDefinition("cda");
    }

    public boolean isValidJsonArray(JXPathContext context, String paramName) {
        return context != null && context.getValue("properties/.[name='" + paramName + "']/value") != null && Utils.isValidJsonArray(context.getValue("properties/.[name='" + paramName + "']/value").toString());
    }
}

