/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.writer.cderunjs;

import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.LabeledValue;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.writer.cderunjs.CdeRunJsHelper;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdeRunJsPropertyTypeWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        String camelName;
        PropertyType prop = (PropertyType)t;
        StringBuilder out = (StringBuilder)output;
        this.writeValuesListInputTypeRenderer(out, prop);
        String fullName = camelName = prop.getCamelName();
        ComponentType owner = prop.getOwner();
        if (owner != null) {
            String modelId = CdeRunJsHelper.getComponentTypeModelId(owner);
            fullName = modelId + "_" + fullName;
        }
        String propVarName = prop.getName() + "Property";
        out.append(NEWLINE);
        out.append("var ");
        out.append(propVarName);
        out.append(" = BasePropertyType.extend({");
        out.append(NEWLINE);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "type", JsonUtils.toJsString(fullName), "\t", true);
        CdeRunJsPropertyTypeWriter.addCommaAndLineSep(out);
        out.append("\t");
        out.append("stub: {");
        out.append(NEWLINE);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "name", JsonUtils.toJsString(camelName), "\t\t", true);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "value", prop.getDefaultValue(), "\t\t", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "description", JsonUtils.toJsString(prop.getLabel()), "\t\t", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "tooltip", JsonUtils.toJsString(prop.getTooltip()), "\t\t", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "type", JsonUtils.toJsString(prop.getInputType()), "\t\t", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "order", String.valueOf(prop.getOrder()), "\t\t", false);
        String cat = prop.getCategory();
        if (!"advanced".equals(cat)) {
            cat = "";
        }
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "classType", JsonUtils.toJsString(cat == null ? "" : cat), "\t\t", false);
        out.append(NEWLINE);
        out.append("\t");
        out.append("}");
        out.append(NEWLINE);
        out.append("});");
        out.append(NEWLINE);
        out.append("PropertiesManager.register(new ");
        out.append(propVarName);
        out.append("());");
        out.append(NEWLINE);
    }

    private void writeValuesListInputTypeRenderer(StringBuilder out, PropertyType prop) {
        String valuesSource = prop.getPossibleValuesSource();
        if (valuesSource != null || prop.getPossibleValueCount() > 0) {
            String rendererName = prop.getInputType() + "Renderer";
            out.append(NEWLINE);
            out.append("var ");
            out.append(rendererName);
            out.append(" = ");
            out.append(prop.getAttribute("BaseRenderer").getValue());
            out.append(".extend({");
            out.append(NEWLINE);
            out.append("\t");
            out.append("selectData: ");
            if (valuesSource != null) {
                out.append(NEWLINE);
                out.append("\t\t");
                out.append(valuesSource);
                out.append(NEWLINE);
            } else {
                out.append("{");
                out.append(NEWLINE);
                boolean isFirst = true;
                for (LabeledValue labeledValue : prop.getPossibleValues()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        CdeRunJsPropertyTypeWriter.addCommaAndLineSep(out);
                    }
                    out.append("\t\t");
                    out.append(JsonUtils.toJsString(labeledValue.getValue()));
                    out.append(": ");
                    out.append(JsonUtils.toJsString(labeledValue.getLabel()));
                }
                out.append(NEWLINE);
                out.append("\t");
                out.append("}");
                out.append(NEWLINE);
            }
            out.append("});");
            out.append(NEWLINE);
        }
    }
}

