/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.writer.cderunjs;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.Attribute;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.PropertyTypeUsage;
import pt.webdetails.cdf.dd.model.meta.writer.cderunjs.CdeRunJsHelper;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdeRunJsComponentTypeWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        ComponentType comp = (ComponentType)t;
        StringBuilder out = (StringBuilder)output;
        Attribute cdeModelIgnoreAttr = comp.tryGetAttribute("cdeModelIgnore");
        if (cdeModelIgnoreAttr != null && "true".equals(cdeModelIgnoreAttr.getValue())) {
            return;
        }
        String name = comp.getName();
        String modelPrefix = CdeRunJsHelper.getComponentTypeModelPrefix(comp);
        String modelName = CdeRunJsHelper.getComponentTypeModelId(comp, modelPrefix);
        String modelVarName = modelName + "Model";
        String label = comp.getLabel();
        String jsTooltip = JsonUtils.toJsString(comp.getTooltip());
        if (comp.getVisible().booleanValue()) {
            String entryName = name + "Entry";
            String entryId = name.toUpperCase() + "_ENTRY";
            String baseEntryType = comp.tryGetAttributeValue("cdePalleteType", "PalleteEntry");
            out.append(NEWLINE);
            out.append("var ");
            out.append(entryName);
            out.append(" = ");
            out.append(baseEntryType);
            out.append(".extend({");
            out.append(NEWLINE);
            CdeRunJsComponentTypeWriter.addJsProperty(out, "id", JsonUtils.toJsString(entryId), "\t", true);
            CdeRunJsComponentTypeWriter.addJsProperty(out, "name", JsonUtils.toJsString(label), "\t", false);
            CdeRunJsComponentTypeWriter.addJsProperty(out, "description", jsTooltip, "\t", false);
            CdeRunJsComponentTypeWriter.addJsProperty(out, "category", JsonUtils.toJsString(comp.getCategory()), "\t", false);
            CdeRunJsComponentTypeWriter.addJsProperty(out, "categoryDesc", JsonUtils.toJsString(comp.getCategoryLabel()), "\t", false);
            CdeRunJsComponentTypeWriter.addCommaAndLineSep(out);
            out.append("\t");
            out.append("getStub: function() {");
            out.append(NEWLINE);
            out.append("\t\t");
            out.append("return ");
            out.append(modelVarName);
            out.append(".getStub();");
            out.append(NEWLINE);
            out.append("\t");
            out.append("}");
            out.append(NEWLINE);
            out.append("});");
            out.append(NEWLINE);
            String collectionName = comp instanceof DataSourceComponentType ? "CDFDDDatasourcesArray" : "CDFDDComponentsArray";
            out.append(collectionName);
            out.append(".push(new ");
            out.append(entryName);
            out.append("());");
            out.append(NEWLINE);
        }
        if (comp.getPropertyUsageCount() > 0) {
            IThingWriterFactory factory = context.getFactory();
            for (PropertyTypeUsage propUsage : comp.getPropertyUsages()) {
                IThingWriter writer;
                if (!propUsage.isOwned()) continue;
                PropertyType prop = propUsage.getProperty();
                try {
                    writer = factory.getWriter(prop);
                }
                catch (UnsupportedThingException ex) {
                    throw new ThingWriteException(ex);
                }
                writer.write(out, context, prop);
            }
        }
        out.append(NEWLINE);
        out.append("var ");
        out.append(modelVarName);
        out.append(" = BaseModel.create({");
        out.append(NEWLINE);
        CdeRunJsComponentTypeWriter.addJsProperty(out, "name", JsonUtils.toJsString(modelName), "\t", true);
        CdeRunJsComponentTypeWriter.addJsProperty(out, "description", jsTooltip, "\t", false);
        if (comp.getLegacyNameCount() > 0) {
            CdeRunJsComponentTypeWriter.addCommaAndLineSep(out);
            out.append("\t");
            out.append("legacyNames: [");
            boolean isFirstLegacyName = true;
            for (String legacyName : comp.getLegacyNames()) {
                if (isFirstLegacyName) {
                    isFirstLegacyName = false;
                } else {
                    out.append(", ");
                }
                out.append(JsonUtils.toJsString(legacyName));
            }
            out.append("]");
        }
        boolean isFirstAttr = true;
        for (Attribute attribute : comp.getAttributes()) {
            String jsAttrName;
            String attName = attribute.getName();
            if ("cdeModelIgnore".equals(attName) || "cdeModelPrefix".equals(attName) || "cdePalleteType".equals(attName)) continue;
            if (isFirstAttr) {
                CdeRunJsComponentTypeWriter.addJsProperty(out, "metas", "{", "\t", false);
                out.append(NEWLINE);
            }
            jsAttrName = StringUtils.isEmpty((String)(jsAttrName = attribute.getName())) ? "meta" : "meta_" + jsAttrName;
            CdeRunJsComponentTypeWriter.addJsProperty(out, JsonUtils.toJsString(jsAttrName), JsonUtils.toJsString(attribute.getValue()), "\t\t", isFirstAttr);
            if (!isFirstAttr) continue;
            isFirstAttr = false;
        }
        if (!isFirstAttr) {
            out.append(NEWLINE);
            out.append("\t");
            out.append("}");
        }
        CdeRunJsComponentTypeWriter.addJsProperty(out, "properties", "[", "\t", false);
        if (comp.getPropertyUsageCount() > 0) {
            boolean isFirstProp = true;
            for (PropertyTypeUsage propUsage : comp.getPropertyUsages()) {
                if (isFirstProp) {
                    isFirstProp = false;
                } else {
                    out.append(",");
                }
                out.append(NEWLINE);
                out.append("\t\t");
                String camelName = propUsage.getProperty().getCamelName();
                String alias = propUsage.getAlias();
                boolean isAliased = !camelName.equals(alias);
                boolean isOwned = propUsage.isOwned();
                String jsName = JsonUtils.toJsString(camelName);
                if (isAliased || isOwned) {
                    out.append("{name: ");
                    out.append(jsName);
                    if (isAliased) {
                        out.append(", alias: ");
                        out.append(JsonUtils.toJsString(alias));
                    }
                    if (isOwned) {
                        out.append(", owned: true");
                    }
                    out.append("}");
                    continue;
                }
                out.append(jsName);
            }
            out.append(NEWLINE);
            out.append("\t");
            out.append("]");
            out.append(NEWLINE);
        }
        out.append("});");
        out.append(NEWLINE);
    }
}

