/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.reader.cdexml;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.Resource;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.XmlPropertyTypeReader;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.fs.XmlFsPluginThingReaderFactory;
import pt.webdetails.cdf.dd.util.Utils;

public abstract class XmlComponentTypeReader {
    private static final Log logger = LogFactory.getLog(XmlComponentTypeReader.class);

    public void read(ComponentType.Builder builder, XmlFsPluginThingReaderFactory factory, Element elem, String sourcePath) throws ThingReadException {
        String compDir = FilenameUtils.getFullPath((String)sourcePath);
        String componentName = this.readBaseProperties(builder, elem, sourcePath);
        this.readModel(builder, elem);
        this.readResourceDependencies(builder, elem, compDir, componentName);
        String srcPath = Utils.getNodeText("Contents/Implementation/Code/@src", (Node)elem);
        if (StringUtils.isNotEmpty((String)srcPath)) {
            builder.setImplementationPath(Utils.joinPath(compDir, srcPath));
        }
        this.readCustomProperties(builder, factory, elem, sourcePath);
        this.readModelProperties(builder, elem);
        List<Element> attributeElems = Utils.selectNodes(elem, "Metadata/*");
        for (Element attributeElem : attributeElems) {
            builder.addAttribute(Utils.getNodeText("@name", (Node)attributeElem), Utils.getNodeText(".", (Node)attributeElem));
        }
    }

    private void readModel(ComponentType.Builder builder, Element elem) {
        String cdeModelIgnoreText = Utils.getNodeText("Contents/Model/@ignore", (Node)elem);
        boolean cdeModelIgnore = cdeModelIgnoreText != null && cdeModelIgnoreText.toLowerCase().equals("true");
        builder.addAttribute("cdeModelIgnore", cdeModelIgnore ? "true" : "false");
        String cdeModelPrefix = Utils.getNodeText("Contents/Model/@prefix", (Node)elem);
        if (StringUtils.isNotEmpty((String)cdeModelPrefix)) {
            builder.addAttribute("cdeModelPrefix", cdeModelPrefix);
        }
        String cdePalleteType = Utils.getNodeText("Header/Type", (Node)elem);
        if (StringUtils.isNotEmpty((String)cdeModelPrefix)) {
            builder.addAttribute("cdePalleteType", cdePalleteType);
        }
    }

    private void readCustomProperties(ComponentType.Builder builder, XmlFsPluginThingReaderFactory factory, Element elem, String sourcePath) {
        List<Element> propElems = Utils.selectNodes(elem, "Contents/Implementation/CustomProperties/*");
        for (Element propElem : propElems) {
            String className = Utils.getNodeText("Header/Override", (Node)propElem);
            if (StringUtils.isEmpty((String)className)) {
                className = "PropertyType";
            }
            XmlPropertyTypeReader propReader = factory.getPropertyTypeReader();
            PropertyType.Builder prop = propReader.read(propElem, sourcePath);
            builder.addProperty(prop);
        }
    }

    private void readModelProperties(ComponentType.Builder builder, Element elem) {
        List<Element> usedPropElems = Utils.selectNodes(elem, "Contents/Model//Property");
        for (Element usedPropElem : usedPropElems) {
            String definitionName = null;
            Element parentElem = usedPropElem.getParent();
            if (parentElem != null && parentElem.getName().equals("Definition")) {
                definitionName = Utils.getNodeText("@name", (Node)parentElem);
            }
            builder.useProperty(Utils.getNodeText("@name", (Node)usedPropElem), Utils.getNodeText(".", (Node)usedPropElem), definitionName);
        }
    }

    private String readBaseProperties(ComponentType.Builder builder, Element elem, String sourcePath) {
        String componentName = elem.selectSingleNode("Header/IName") != null ? elem.selectSingleNode("Header/IName").getText() : null;
        builder.setName(componentName).setLabel(Utils.getNodeText("Header/Name", (Node)elem)).setTooltip(Utils.getNodeText("Header/Description", (Node)elem)).setCategory(Utils.getNodeText("Header/Category", (Node)elem)).setCategoryLabel(Utils.getNodeText("Header/CatDescription", (Node)elem)).setSourcePath(sourcePath).setVersion(Utils.getNodeText("Header/Version", (Node)elem));
        String visibleText = Utils.getNodeText("Header/Visible", (Node)elem);
        if (StringUtils.isNotEmpty((String)visibleText)) {
            builder.setVisible("true".equalsIgnoreCase(visibleText));
        }
        List legacyNamesElems = elem.selectNodes("Header/LegacyIName");
        for (Element legacyNameElem : legacyNamesElems) {
            String legacyName = legacyNameElem.getStringValue();
            if (!StringUtils.isNotBlank((String)legacyName)) continue;
            builder.addLegacyName(legacyName);
        }
        return componentName;
    }

    private void readResourceDependencies(ComponentType.Builder builder, Element compElem, String compDir, String compName) {
        List depElems = compElem.selectNodes("Contents/Implementation/Dependencies/*");
        for (Element depElem : depElems) {
            Resource.Builder resourceBuilder = this.createResource(Resource.Type.SCRIPT, compDir, depElem, compName);
            if (resourceBuilder == null) continue;
            builder.addResource(resourceBuilder);
        }
        List styleElems = compElem.selectNodes("Contents/Implementation/Styles/*");
        for (Element styleElem : styleElems) {
            Resource.Builder resourceBuilder = this.createResource(Resource.Type.STYLE, compDir, styleElem, compName);
            if (resourceBuilder == null) continue;
            builder.addResource(resourceBuilder);
        }
        List rawElems = compElem.selectNodes("Contents/Implementation/Raw/*");
        for (Element rawElem : rawElems) {
            builder.addResource(new Resource.Builder().setType(Resource.Type.STYLE).setApp(Utils.getNodeText("@app", (Node)rawElem)).setName(Utils.getNodeText("@name", (Node)rawElem)).setVersion(Utils.getNodeText("@version", (Node)rawElem)).setSource(Utils.getNodeText(".", (Node)rawElem)));
        }
    }

    private Resource.Builder createResource(Resource.Type type, String compDir, Element resourceElement, String componentName) {
        String dependencySource = Utils.getNodeText("@src", (Node)resourceElement);
        String name = Utils.getNodeText(".", (Node)resourceElement);
        if (StringUtils.isEmpty((String)dependencySource)) {
            logger.error((Object)String.format("Dependency with empty src in component '%s'. Skipping.", componentName));
            return null;
        }
        if (StringUtils.isEmpty((String)name)) {
            logger.warn((Object)String.format("Dependency with empty name in component '%s', src='%s'.", componentName, dependencySource));
        }
        return new Resource.Builder().setType(type).setApp(Utils.getNodeText("@app", (Node)resourceElement)).setName(Utils.getNodeText(".", (Node)resourceElement)).setVersion(Utils.getNodeText("@version", (Node)resourceElement)).setSource(Utils.joinPath(compDir, dependencySource));
    }
}

