/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.validation.DuplicateAttributeError;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.LabeledValue;
import pt.webdetails.cdf.dd.model.meta.MetaObject;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class PropertyType
extends MetaObject {
    protected static Log _logger = LogFactory.getLog(PropertyType.class);
    public static final String CAT_ADVANCED = "advanced";
    public static final String CAT_ADVANCED_DESC = "Advanced";
    public static final String DEF_BASE_TYPE = "BaseProperty";
    public static final ValueType DEF_VALUE_TYPE = ValueType.STRING;
    public static final String DEF_NONLIST_INPUTTYPE = "String";
    private final ComponentType _owner;
    private final String _base;
    private final ValueType _valueType;
    private final String _defaultValue;
    private final String _inputType;
    private final int _order;
    private final String _possibleValuesSource;
    private final Map<String, LabeledValue> _possibleValuesByValue;

    protected PropertyType(Builder builder, ComponentType owner) throws ValidationException {
        super(builder);
        String inputType;
        this._owner = owner;
        this._base = StringUtils.isEmpty((String)builder._base) ? DEF_BASE_TYPE : builder._base;
        this._valueType = builder._valueType == null ? DEF_VALUE_TYPE : builder._valueType;
        this._defaultValue = this.processDefaultValue(this._valueType, builder._defaultValue);
        this._order = builder._order;
        if (StringUtils.isNotEmpty((String)builder._possibleValuesSource)) {
            if (builder.getPossibleValueCount() > 0) {
                _logger.warn((Object)String.format("PropertyType '%s' has a possible values source specified. Ignoring provided static values list.", this.getName()));
            }
            this._possibleValuesSource = builder._possibleValuesSource;
        } else {
            this._possibleValuesSource = null;
        }
        if (this._possibleValuesSource == null && builder.getPossibleValueCount() > 0) {
            this._possibleValuesByValue = new LinkedHashMap<String, LabeledValue>();
            for (LabeledValue.Builder labeledValueBuilder : builder._possibleValues) {
                LabeledValue labeledValue = labeledValueBuilder.build();
                if (this._possibleValuesByValue.containsKey(labeledValue.getValue())) {
                    _logger.warn((Object)new DuplicateAttributeError(labeledValue.getValue()));
                    continue;
                }
                this._possibleValuesByValue.put(labeledValue.getValue(), labeledValue);
            }
        } else {
            this._possibleValuesByValue = null;
        }
        if (StringUtils.isEmpty((String)(inputType = builder._inputType))) {
            inputType = this._possibleValuesByValue == null && this._possibleValuesSource == null ? DEF_NONLIST_INPUTTYPE : this.getName() + "Custom";
        }
        this._inputType = inputType;
    }

    private String processDefaultValue(ValueType valueType, String defaultValue) {
        if (StringUtils.isEmpty((String)defaultValue)) {
            switch (valueType) {
                case ARRAY: {
                    defaultValue = "\"[]\"";
                    break;
                }
                case NUMBER: 
                case BOOLEAN: 
                case FUNCTION: 
                case STRING: {
                    defaultValue = "\"\"";
                    break;
                }
                default: {
                    defaultValue = "";
                    break;
                }
            }
        } else {
            switch (valueType) {
                case STRING: {
                    defaultValue = JsonUtils.toJsString(defaultValue);
                }
            }
        }
        return defaultValue;
    }

    @Override
    public String getKind() {
        return "PropertyType";
    }

    public final ComponentType getOwner() {
        return this._owner;
    }

    public final String getBase() {
        return this._base;
    }

    public final String getDefaultValue() {
        return this._defaultValue;
    }

    public final String getInputType() {
        return this._inputType;
    }

    public final ValueType getValueType() {
        return this._valueType;
    }

    public int getOrder() {
        return this._order;
    }

    public final boolean isAdvanced() {
        return CAT_ADVANCED.equals(this.getCategory());
    }

    public String getPossibleValuesSource() {
        return this._possibleValuesSource;
    }

    public LabeledValue getPossibleValue(String value) {
        LabeledValue possibleValue;
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("value");
        }
        LabeledValue labeledValue = possibleValue = this._possibleValuesByValue != null ? this._possibleValuesByValue.get(value) : null;
        if (possibleValue == null) {
            throw new IllegalArgumentException("There is no possible value with a value of '" + value + "'.");
        }
        return possibleValue;
    }

    public Iterable<LabeledValue> getPossibleValues() {
        return this._possibleValuesByValue != null ? this._possibleValuesByValue.values() : Collections.emptyList();
    }

    public int getPossibleValueCount() {
        return this._possibleValuesByValue != null ? this._possibleValuesByValue.size() : 0;
    }

    public static class Builder
    extends MetaObject.Builder {
        private String _base;
        private ValueType _valueType;
        private String _defaultValue;
        private String _inputType;
        private int _order;
        private String _possibleValuesSource;
        private List<LabeledValue.Builder> _possibleValues;

        public ValueType getValueType() {
            return this._valueType;
        }

        public Builder setValueType(ValueType valueType) {
            this._valueType = valueType;
            return this;
        }

        public String getBase() {
            return this._base;
        }

        public Builder setBase(String base) {
            this._base = base;
            return this;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public Builder setDefaultValue(String defaultValue) {
            this._defaultValue = defaultValue;
            return this;
        }

        public String getInputType() {
            return this._inputType;
        }

        public Builder setInputType(String inputType) {
            this._inputType = inputType;
            return this;
        }

        public int getOrder() {
            return this._order;
        }

        public Builder setOrder(int order) {
            this._order = order;
            return this;
        }

        public String getPossibleValuesSource() {
            return this._possibleValuesSource;
        }

        public Builder setPossibleValuesSource(String source) {
            this._possibleValuesSource = StringUtils.isEmpty((String)source) ? null : source;
            return this;
        }

        public MetaObject.Builder addPossibleValue(LabeledValue.Builder possibleValue) {
            if (possibleValue == null) {
                throw new IllegalArgumentException("possibleValue");
            }
            if (this._possibleValues == null) {
                this._possibleValues = new ArrayList<LabeledValue.Builder>();
            }
            this._possibleValues.add(possibleValue);
            return this;
        }

        public MetaObject.Builder addPossibleValue(String value, String label) {
            return this.addPossibleValue(new LabeledValue.Builder().setValue(value).setLabel(label));
        }

        public Iterable<LabeledValue.Builder> getPossibleValues() {
            return this._possibleValues != null ? this._possibleValues : Collections.emptyList();
        }

        public int getPossibleValueCount() {
            return this._possibleValues != null ? this._possibleValues.size() : 0;
        }

        public PropertyType build(ComponentType owner) throws ValidationException {
            return new PropertyType(this, owner);
        }

        public PropertyType build() throws ValidationException {
            return new PropertyType(this, null);
        }
    }

    public static enum ValueType {
        STRING,
        BOOLEAN,
        NUMBER,
        FUNCTION,
        ARRAY,
        QUERY,
        LITERAL,
        VOID;

    }
}

