/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cggrunjs;

import net.sf.json.JSONArray;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cggrunjs.CggRunJsComponentWriteContext;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CggRunJsDataSourceComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CggRunJsComponentWriteContext)context, (DataSourceComponent)t);
    }

    public void write(StringBuilder out, CggRunJsComponentWriteContext context, DataSourceComponent comp) throws ThingWriteException {
        String jsParamsArray = comp.tryGetPropertyValue("parameters", null);
        if (jsParamsArray != null) {
            this.renderParameters(out, JSONArray.fromObject((Object)jsParamsArray));
        }
    }

    private void renderParameters(StringBuilder out, JSONArray params) {
        if (params.isEmpty()) {
            return;
        }
        out.append("cgg.initParameter");
        out.append(NEWLINE);
        for (JSONArray param : params) {
            String paramName = param.get(0).toString();
            String defaultValue = param.get(1).toString();
            out.append("(");
            out.append(JsonUtils.toJsString(paramName));
            out.append(", ");
            out.append(JsonUtils.toJsString(defaultValue));
            out.append(")");
            out.append(NEWLINE);
        }
        out.append(";");
    }
}

