/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsPropertyBindingWriter;

public class CdfRunJsGenericPropertyBindingWriter
extends CdfRunJsPropertyBindingWriter {
    @Override
    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, PropertyBinding propBind) throws ThingWriteException {
        String indent = context.getIndent();
        String jsValue = this.writeValue(propBind);
        if (StringUtils.isNotEmpty((String)jsValue)) {
            CdfRunJsGenericPropertyBindingWriter.addJsProperty(out, propBind.getAlias(), jsValue, indent, context.isFirstInList());
            context.setIsFirstInList(false);
        }
    }

    private String writeValue(PropertyBinding propBind) {
        String canonicalValue = propBind.getValue();
        if (StringUtils.isNotEmpty((String)canonicalValue)) {
            switch (propBind.getProperty().getValueType()) {
                case STRING: {
                    return this.writeString(canonicalValue);
                }
                case BOOLEAN: {
                    return this.writeBoolean(canonicalValue);
                }
                case NUMBER: {
                    return this.writeNumber(canonicalValue);
                }
                case ARRAY: {
                    return this.writeArray(canonicalValue);
                }
                case FUNCTION: {
                    return this.writeFunction(canonicalValue);
                }
                case LITERAL: {
                    return this.writeLiteral(canonicalValue);
                }
                case QUERY: {
                    return this.writeQuery(canonicalValue);
                }
            }
        }
        return "";
    }

    private String writeQuery(String canonicalValue) {
        throw new UnsupportedOperationException("Feature implemented in DatasourceProperty Writer -- something went wrong!");
    }
}

