/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsPropertyBindingWriter;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdfRunJsDataSourcePropertyBindingWriter
extends CdfRunJsPropertyBindingWriter {
    protected static final Log logger = LogFactory.getLog(CdfRunJsDataSourcePropertyBindingWriter.class);
    private static final String META_TYPE_CDA = "CDA";
    private static final String META_TYPE_CPK = "CPK";

    protected static String buildJsStringValue(String value) {
        return JsonUtils.toJsString(CdfRunJsDataSourcePropertyBindingWriter.replaceParameters(value == null ? "" : value));
    }

    protected static String replaceParameters(String value) {
        if (value != null) {
            Pattern pattern = Pattern.compile("\\$\\{[^}]*\\}");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String parameter = matcher.group();
                value = value.replace(matcher.group(), "Dashboards.ev(" + parameter.substring(2, parameter.length() - 1) + ")");
            }
        }
        return value;
    }

    @Override
    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, PropertyBinding propBind) throws ThingWriteException {
        DataSourceComponent dataSourceComp = this.getDataSourceComponent(context, propBind);
        if (dataSourceComp == null) {
            return;
        }
        String dataAccessId = dataSourceComp.tryGetPropertyValue("dataAccessId", null);
        if (dataAccessId != null) {
            this.renderCdaDatasource(out, context, dataSourceComp, dataAccessId);
        } else {
            String metaType = dataSourceComp.getMeta().tryGetAttributeValue("", "");
            if (StringUtils.isEmpty((String)metaType)) {
                this.renderDatasource(out, context, dataSourceComp);
            } else if (metaType.equals(META_TYPE_CDA)) {
                this.renderBuiltinCdaDatasource(out, context, dataSourceComp);
            } else if (metaType.equals(META_TYPE_CPK)) {
                this.renderCpkDatasource(out, context, dataSourceComp);
            } else {
                throw new ThingWriteException("Cannot render a data source property of meta type '" + metaType + "'.");
            }
        }
    }

    protected DataSourceComponent getDataSourceComponent(CdfRunJsDashboardWriteContext context, PropertyBinding propBind) {
        String dataSourceName = propBind.getValue();
        return StringUtils.isEmpty((String)dataSourceName) ? null : context.getDashboard().tryGetDataSource(dataSourceName);
    }

    protected void renderCdaDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp, String dataAccessId) {
        String cdaPath;
        String indent = context.getIndent();
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "dataAccessId", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataAccessId), indent, context.isFirstInList());
        context.setIsFirstInList(false);
        String outputIndexId = dataSourceComp.tryGetPropertyValue("outputIndexId", null);
        if (outputIndexId != null) {
            CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "outputIndexId", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(outputIndexId), indent, false);
        }
        if ((cdaPath = dataSourceComp.tryGetPropertyValue("cdaPath", null)) != null) {
            CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "path", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(cdaPath), indent, false);
        } else {
            String solution = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("solution", ""));
            CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "solution", solution, indent, false);
            String path = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("path", ""));
            CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "path", path, indent, false);
            String file = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("file", ""));
            CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "file", file, indent, false);
        }
    }

    protected void renderBuiltinCdaDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp) {
        String indent = context.getIndent();
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "dataAccessId", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.getName()), indent, context.isFirstInList());
        context.setIsFirstInList(false);
        String cdeFilePath = context.getDashboard().getSourcePath();
        if (cdeFilePath.contains(".wcdf")) {
            logger.error((Object)"renderBuiltinCdaDatasource: [fileName] receiving a .wcdf when a .cdfde was expected!");
            cdeFilePath = cdeFilePath.replace(".wcdf", ".cda");
        }
        String cdaFilePath = cdeFilePath.replaceAll(".cdfde", ".cda");
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "path", JsonUtils.toJsString(cdaFilePath), indent, false);
    }

    protected void renderCpkDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp) {
        String indent = context.getIndent();
        DataSourceComponentType compType = dataSourceComp.getMeta();
        String endPoint = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(compType.tryGetAttributeValue("endpoint", ""));
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "endpoint", endPoint, indent, context.isFirstInList());
        context.setIsFirstInList(false);
        String pluginId = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(compType.tryGetAttributeValue("pluginId", ""));
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "pluginId", pluginId, indent, false);
        String stepName = dataSourceComp.tryGetPropertyValueByName("stepName", "OUTPUT");
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "stepName", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(stepName), indent, false);
        String kettleOutput = dataSourceComp.tryGetPropertyValueByName("kettleOutput", "Infered");
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "kettleOutput", CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(kettleOutput), indent, false);
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "queryType", JsonUtils.toJsString("cpk"), indent, false);
    }

    protected void renderDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp) {
        String queryType;
        String indent = context.getIndent();
        String jndi = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("jndi", ""));
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "jndi", jndi, indent, context.isFirstInList());
        context.setIsFirstInList(false);
        String catalog = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("catalog", ""));
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "catalog", catalog, indent, false);
        String cube = CdfRunJsDataSourcePropertyBindingWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("cube", ""));
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "cube", cube, indent, false);
        String query = dataSourceComp.tryGetPropertyValue("mdxquery", null);
        if (query != null) {
            queryType = "mdx";
        } else {
            queryType = "sql";
            query = dataSourceComp.tryGetPropertyValue("sqlquery", null);
        }
        if (query != null) {
            query = this.writeFunction(query);
        }
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "query", CdfRunJsDataSourcePropertyBindingWriter.replaceParameters(query), indent, false);
        CdfRunJsDataSourcePropertyBindingWriter.addJsProperty(out, "queryType", JsonUtils.toJsString(queryType), indent, false);
    }

    private static class PropertyValue {
        public static final String CPK_QUERY_TYPE = "cpk";
        public static final String MDX_QUERY_TYPE = "mdx";
        public static final String SQL_QUERY_TYPE = "sql";

        private PropertyValue() {
        }
    }

    private static class PropertyName {
        public static final String QUERY_TYPE = "queryType";
        public static final String QUERY = "query";
        public static final String SQL_QUERY = "sqlquery";
        public static final String MDX_QUERY = "mdxquery";
        public static final String JNDI = "jndi";
        public static final String CATALOG = "catalog";
        public static final String CUBE = "cube";
        public static final String DATA_ACCESS_ID = "dataAccessId";
        public static final String ENDPOINT = "endpoint";
        public static final String PLUGIN_ID = "pluginId";
        public static final String KETTLE_OUTPUT_FORMAT = "kettleOutput";
        public static final String KETTLE_OUTPUT_STEP_NAME = "stepName";
        public static final String OUTPUT_INDEX_ID = "outputIndexId";
        public static final String SOLUTION = "solution";
        public static final String PATH = "path";
        public static final String FILE = "file";

        private PropertyName() {
        }
    }
}

