/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.VisualComponent;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.render.DependenciesManager;
import pt.webdetails.cdf.dd.render.RenderLayout;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.packager.StringFilter;

public abstract class CdfRunJsDashboardWriter
extends JsWriterAbstract
implements IThingWriter {
    private static final Log logger = LogFactory.getLog(CdfRunJsDashboardWriter.class);
    private static final String EPILOGUE = CdfRunJsDashboardWriter.wrapJsScriptTags("Dashboards.init();");

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((CdfRunJsDashboardWriteResult.Builder)output, (CdfRunJsDashboardWriteContext)context, (Dashboard)t);
    }

    public abstract String getType();

    public void write(CdfRunJsDashboardWriteResult.Builder builder, CdfRunJsDashboardWriteContext ctx, Dashboard dash) throws ThingWriteException {
        String footer;
        String template;
        assert (dash == ctx.getDashboard());
        DashboardWcdfDescriptor wcdf = dash.getWcdf();
        try {
            template = this.readTemplate(wcdf);
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read style template file.", ex);
        }
        template = ctx.replaceTokens(template);
        try {
            footer = Util.toString((InputStream)CdeEnvironment.getPluginSystemReader().getFileInputStream("resources/patch-footer.html"));
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read footer file.", ex);
        }
        String layout = ctx.replaceTokensAndAlias(this.writeLayout(ctx, dash));
        String components = ctx.replaceTokensAndAlias(this.writeComponents(ctx, dash));
        String content = this.writeContent(layout, components);
        String header = ctx.replaceTokens(this.writeHeaders(content, ctx));
        template = template.replaceAll("\\@HEADER\\@", Matcher.quoteReplacement(header) + "\\@HEADER\\@").replaceAll("\\@FOOTER\\@", Matcher.quoteReplacement(footer)).replaceAll("\\@CONTENT\\@", Matcher.quoteReplacement(content));
        builder.setTemplate(template).setHeader(header).setLayout(layout).setComponents(components).setContent(content).setFooter(footer).setLoadedDate(ctx.getDashboard().getSourceDate());
    }

    protected String readTemplate(DashboardWcdfDescriptor wcdf) throws IOException {
        return CdfRunJsDashboardWriter.readStyleTemplateOrDefault(wcdf.getStyle());
    }

    protected String writeLayout(CdfRunJsDashboardWriteContext context, Dashboard dash) {
        if (dash.getLayoutCount() == 1) {
            JXPathContext docXP = dash.getLayout("TODO").getLayoutXPContext();
            try {
                return this.getLayoutRenderer(docXP, context).render(context.getOptions().getAliasPrefix());
            }
            catch (Exception ex) {
                logger.error((Object)"Error rendering layout", (Throwable)ex);
            }
        }
        return "";
    }

    protected Renderer getLayoutRenderer(JXPathContext docXP, CdfRunJsDashboardWriteContext context) {
        return new RenderLayout(docXP, context);
    }

    protected String writeComponents(CdfRunJsDashboardWriteContext context, Dashboard dash) throws ThingWriteException {
        DashboardWcdfDescriptor wcdf = dash.getWcdf();
        StringBuilder out = new StringBuilder();
        StringBuilder widgetsOut = new StringBuilder();
        out.append("wcdfSettings = ");
        out.append(wcdf.toJSON().toString(2));
        out.append(';');
        out.append(NEWLINE);
        out.append(NEWLINE);
        boolean isFirstComp = true;
        StringBuilder addCompIds = new StringBuilder();
        boolean isFirstAddComp = true;
        IThingWriterFactory factory = context.getFactory();
        Iterable<Component> comps = dash.getRegulars();
        for (Component comp : comps) {
            StringBuilder out2;
            IThingWriter writer;
            if (!StringUtils.isNotEmpty((String)comp.getName())) continue;
            try {
                writer = factory.getWriter(comp);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            boolean isWidget = comp instanceof WidgetComponent;
            StringBuilder stringBuilder = out2 = isWidget ? widgetsOut : out;
            if (!isFirstComp) {
                out2.append(NEWLINE);
            }
            if (comp instanceof VisualComponent && !(comp instanceof WidgetComponent)) {
                if (isFirstAddComp) {
                    isFirstAddComp = false;
                } else {
                    addCompIds.append(", ");
                }
                addCompIds.append(context.getId(comp));
            }
            writer.write(out2, context, comp);
            isFirstComp = false;
        }
        if (!isFirstAddComp) {
            out.append(NEWLINE);
            out.append("Dashboards.addComponents([");
            out.append((CharSequence)addCompIds);
            out.append("]);");
            out.append(NEWLINE);
        }
        out.append((CharSequence)widgetsOut);
        return out.toString();
    }

    protected String writeHeaders(String contents, CdfRunJsDashboardWriteContext context) {
        String cdfDeps;
        CdfRunJsDashboardWriteOptions options = context.getOptions();
        DashboardWcdfDescriptor wcdf = context.getDashboard().getWcdf();
        String title = "<title>" + wcdf.getTitle() + "</title>";
        try {
            cdfDeps = CdeEngine.getEnv().getCdfIncludes(contents, this.getType(), options.isDebug(), options.isAbsolute(), options.getAbsRoot(), options.getScheme());
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get cdf includes");
            cdfDeps = "";
        }
        final String baseUrl = options.isAbsolute() ? (!StringUtils.isEmpty((String)options.getAbsRoot()) ? options.getSchemedRoot() + "/" : CdeEngine.getInstance().getEnvironment().getUrlProvider().getWebappContextRoot()) : "";
        StringFilter cssFilter = new StringFilter(){

            public String filter(String input) {
                return String.format("\t\t<link href=\"%s%s\" rel=\"stylesheet\" type=\"text/css\" />\n", baseUrl, baseUrl.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
            }

            public String filter(String input, String baseUrl2) {
                return String.format("\t\t<link href=\"%s%s\" rel=\"stylesheet\" type=\"text/css\" />\n", baseUrl2, baseUrl2.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
            }
        };
        StringFilter jsFilter = new StringFilter(){

            public String filter(String input) {
                return String.format("\t\t<script language=\"javascript\" type=\"text/javascript\" src=\"%s%s\"></script>\n", baseUrl, baseUrl.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
            }

            public String filter(String input, String baseUrl2) {
                return String.format("\t\t<script language=\"javascript\" type=\"text/javascript\" src=\"%s%s\"></script>\n", baseUrl2, baseUrl2.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
            }
        };
        DependenciesManager depMgr = DependenciesManager.getInstance();
        boolean isPackaged = !options.isDebug();
        String scriptDeps = depMgr.getPackage("CDF").getDependencies(jsFilter, isPackaged);
        String styleDeps = depMgr.getPackage("CDF-CSS").getDependencies(cssFilter, isPackaged);
        String rawDeps = depMgr.getPackage("CDF-RAW").getRawDependencies(false);
        return title + cdfDeps + rawDeps + scriptDeps + styleDeps;
    }

    protected static String readStyleTemplateOrDefault(String styleName) throws IOException {
        if (StringUtils.isNotEmpty((String)styleName)) {
            try {
                return CdfRunJsDashboardWriter.readStyleTemplate(styleName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return CdfRunJsDashboardWriter.readStyleTemplate("Clean");
    }

    protected static String readStyleTemplate(String styleName) throws IOException {
        return CdfRunJsDashboardWriter.readTemplateFile(CdeEnvironment.getPluginResourceLocationManager().getStyleResourceLocation(styleName));
    }

    protected static String readTemplateFile(String templateFile) throws IOException {
        try {
            if (CdeEnvironment.getPluginRepositoryReader().fileExists(templateFile)) {
                return Util.toString((InputStream)CdeEnvironment.getPluginRepositoryReader().getFileInputStream(templateFile));
            }
            if (CdeEnvironment.getPluginSystemReader().fileExists(templateFile)) {
                return Util.toString((InputStream)CdeEnvironment.getPluginSystemReader().getFileInputStream(templateFile));
            }
            if (Utils.getAppropriateReadAccess(templateFile).fileExists(templateFile)) {
                return Util.toString((InputStream)Utils.getAppropriateReadAccess(templateFile).getFileInputStream(templateFile));
            }
            return Util.toString((InputStream)CdeEnvironment.getUserContentAccess().getFileInputStream(templateFile));
        }
        catch (IOException ex) {
            logger.error((Object)MessageFormat.format("Couldn't open template file '{0}'.", templateFile), (Throwable)ex);
            throw ex;
        }
    }

    private String writeContent(String layout, String components) {
        StringBuilder out = new StringBuilder();
        out.append(layout);
        CdfRunJsDashboardWriter.wrapJsScriptTags(out, components);
        out.append(EPILOGUE);
        return out.toString();
    }
}

