/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdfRunJsWidgetComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    private static final Log _logger = LogFactory.getLog(CdfRunJsWidgetComponentWriter.class);

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CdfRunJsDashboardWriteContext)context, (WidgetComponent)t);
    }

    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, WidgetComponent comp) throws ThingWriteException {
        DashboardManager dashMgr = DashboardManager.getInstance();
        CdfRunJsDashboardWriteOptions options = context.getOptions().addAliasPrefix(comp.getName());
        String newAliasPrefix = options.getAliasPrefix();
        CdfRunJsDashboardWriteResult dashResult = dashMgr.getDashboardCdfRunJs(comp.getWcdfPath(), options, context.isBypassCacheRead());
        out.append(dashResult.getComponents());
        this.writeParameters(out, comp, newAliasPrefix);
    }

    private void writeParameters(StringBuilder out, WidgetComponent comp, String aliasPrefix) {
        if (comp.getPropertyBindingCount() > 0) {
            Iterable<PropertyBinding> props = comp.getPropertyBindings();
            for (PropertyBinding prop : props) {
                if ("parameters".equalsIgnoreCase(prop.getAlias()) || "xActionArrayParameter".equalsIgnoreCase(prop.getName())) {
                    String paramsAssocList = prop.getValue();
                    if (!StringUtils.isNotEmpty((String)paramsAssocList)) continue;
                    this.writeParametersAssocList(out, paramsAssocList, aliasPrefix);
                    continue;
                }
                if (!"parameter".equalsIgnoreCase(prop.getInputType())) continue;
                this.writeJsSyncParameter(out, prop.getAlias(), prop.getValue(), aliasPrefix);
            }
        }
    }

    private void writeParametersAssocList(StringBuilder out, String paramsAssocList, String aliasPrefix) {
        try {
            JSONArray params = new JSONArray(paramsAssocList);
            int L = params.length();
            for (int i = 0; i < L; ++i) {
                JSONArray line = params.getJSONArray(i);
                String dashParam = "${p:" + line.getString(1) + "}";
                this.writeJsSyncParameter(out, line.getString(0), dashParam, aliasPrefix);
            }
        }
        catch (JSONException ex) {
            _logger.error((Object)"Could not write widget parameters in association list", (Throwable)ex);
        }
    }

    private void writeJsSyncParameter(StringBuilder out, String widgetLocalProp, String dashParam, String aliasPrefix) {
        String widgetProp = Component.composeIds(aliasPrefix, widgetLocalProp);
        out.append("Dashboards.syncParametersOnInit(");
        out.append(JsonUtils.toJsString(dashParam));
        out.append(", ");
        out.append(JsonUtils.toJsString(widgetProp));
        out.append(");");
    }
}

