/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs;

import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.CodeComponent;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.GenericComponent;
import pt.webdetails.cdf.dd.model.inst.ParameterComponent;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsCodeComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsDateParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsExpressionParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsGenericComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsWidgetComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsBlueprintDashboardWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsBlueprintWidgetWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsBootstrapDashboardWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsBootstrapWidgetWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsMobileDashboardWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsCdaDataSourcePropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsDataSourcePropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsGenericPropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsJFreeChartDataSourcePropertyBindingWriter;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;

public class CdfRunJsThingWriterFactory
implements IThingWriterFactory {
    public CdfRunJsDashboardWriter getDashboardWriter(Dashboard dashboard) {
        DashboardWcdfDescriptor wcdf = dashboard.getWcdf();
        DashboardWcdfDescriptor.DashboardRendererType rendererType = wcdf.getParsedRendererType();
        if (rendererType == DashboardWcdfDescriptor.DashboardRendererType.MOBILE) {
            return new CdfRunJsMobileDashboardWriter();
        }
        if (rendererType == DashboardWcdfDescriptor.DashboardRendererType.BOOTSTRAP) {
            return wcdf.isWidget() ? new CdfRunJsBootstrapWidgetWriter() : new CdfRunJsBootstrapDashboardWriter();
        }
        return wcdf.isWidget() ? new CdfRunJsBlueprintWidgetWriter() : new CdfRunJsBlueprintDashboardWriter();
    }

    @Override
    public IThingWriter getWriter(Thing t) throws UnsupportedThingException {
        if (t == null) {
            throw new IllegalArgumentException("t");
        }
        String kind = t.getKind();
        if ("Component".equals(kind)) {
            Class<?> compClass = t.getClass();
            if (GenericComponent.class.isAssignableFrom(compClass)) {
                if (WidgetComponent.class.isAssignableFrom(compClass)) {
                    return new CdfRunJsWidgetComponentWriter();
                }
                return new CdfRunJsGenericComponentWriter();
            }
            if (ParameterComponent.class.isAssignableFrom(compClass)) {
                ParameterComponent paramComp = (ParameterComponent)t;
                String typeName = paramComp.getMeta().getName().toLowerCase();
                if (typeName.equals("parameter") || typeName.equals("olapparameter")) {
                    return new CdfRunJsParameterComponentWriter();
                }
                if (typeName.equals("dateparameter")) {
                    return new CdfRunJsDateParameterComponentWriter();
                }
                if (typeName.equals("javascriptparameter")) {
                    return new CdfRunJsExpressionParameterComponentWriter();
                }
            }
            if (CodeComponent.class.isAssignableFrom(compClass)) {
                return new CdfRunJsCodeComponentWriter();
            }
        } else {
            if ("PropertyBinding".equals(kind)) {
                PropertyBinding propBind = (PropertyBinding)t;
                String propName = propBind.getName().toLowerCase();
                if (propName.equals("datasource")) {
                    return new CdfRunJsDataSourcePropertyBindingWriter();
                }
                if (propName.equals("cdadatasource")) {
                    return new CdfRunJsCdaDataSourcePropertyBindingWriter();
                }
                if (propName.equals("jfreechartdatasource")) {
                    return new CdfRunJsJFreeChartDataSourcePropertyBindingWriter();
                }
                return new CdfRunJsGenericPropertyBindingWriter();
            }
            if ("Dashboard".equals(kind)) {
                return this.getDashboardWriter((Dashboard)t);
            }
        }
        throw new UnsupportedThingException(kind, t.getId());
    }
}

