/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.reader.cdfdejs;

import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.reader.IThingReadContext;
import pt.webdetails.cdf.dd.model.core.reader.IThingReader;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.LayoutComponent;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsReadContext;
import pt.webdetails.cdf.dd.model.meta.DashboardType;

public class CdfdeJsDashboardReader
implements IThingReader {
    private static final Logger logger = LoggerFactory.getLogger(CdfdeJsDashboardReader.class);

    @Override
    public Dashboard.Builder read(IThingReadContext context, Object source, String sourcePath) throws ThingReadException {
        Dashboard.Builder builder = new Dashboard.Builder();
        this.read((Thing.Builder)builder, context, source, sourcePath);
        return builder;
    }

    @Override
    public void read(Thing.Builder builder, IThingReadContext context, Object source, String sourcePath) throws ThingReadException {
        this.read((Dashboard.Builder)builder, (CdfdeJsReadContext)context, (JXPathContext)source, sourcePath);
    }

    public void read(Dashboard.Builder builder, CdfdeJsReadContext context, JXPathContext source, String sourcePath) throws ThingReadException {
        IThingReader reader;
        builder.setMeta(DashboardType.getInstance());
        builder.setSourcePath(sourcePath);
        builder.setWcdf(context.getWcdf());
        this.readKind(builder, "Component", source, source.iteratePointers("/components/rows"), context, sourcePath);
        this.readKind(builder, "Component", source, source.iteratePointers("/datasources/rows"), context, sourcePath);
        try {
            reader = context.getFactory().getReader("Component", "layout", null);
            if (reader == null) {
                return;
            }
        }
        catch (UnsupportedThingException ex) {
            logger.error("While rendering dashboard. " + ex);
            return;
        }
        LayoutComponent.Builder compBuilder = (LayoutComponent.Builder)reader.read(context, source, sourcePath);
        builder.addComponent(compBuilder);
    }

    private void readKind(Dashboard.Builder builder, String thingKind, JXPathContext source, Iterator<Pointer> componentPointers, CdfdeJsReadContext context, String sourcePath) throws ThingReadException {
        while (componentPointers.hasNext()) {
            IThingReader reader;
            Pointer componentPointer = componentPointers.next();
            JXPathContext compXP = source.getRelativeContext(componentPointer);
            String className = (String)compXP.getValue("type");
            if (className != null && className.equalsIgnoreCase("label")) continue;
            try {
                reader = context.getFactory().getReader(thingKind, className, null);
            }
            catch (UnsupportedThingException ex) {
                logger.error("While rendering dashboard. " + ex);
                continue;
            }
            Component.Builder compBuilder = (Component.Builder)reader.read(context, compXP, sourcePath);
            builder.addComponent(compBuilder);
        }
    }
}

