/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.validation.RequiredAttributeError;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.ExpectedPropertyBinding;
import pt.webdetails.cdf.dd.model.inst.ExtensionPropertyBinding;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.validation.ComponentUnresolvedPropertyBindingError;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.MetaObject;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.PropertyTypeUsage;
import pt.webdetails.cdf.dd.util.Utils;

public abstract class UnresolvedPropertyBinding
extends PropertyBinding {
    private UnresolvedPropertyBinding() throws UnsupportedOperationException, ValidationException {
        super(null, null, null);
        throw new UnsupportedOperationException("Class cannot be instantiated");
    }

    public static final class Builder
    extends PropertyBinding.Builder {
        private String _alias;
        private String _inputType;

        @Override
        public String getAlias() {
            return this._alias;
        }

        public Builder setAlias(String alias) {
            this._alias = alias;
            return this;
        }

        public String getInputType() {
            return this._inputType;
        }

        public Builder setInputType(String inputType) {
            this._inputType = inputType;
            return this;
        }

        @Override
        public PropertyBinding build(Component owner, MetaModel metaModel) throws ValidationException {
            if (owner == null) {
                throw new IllegalArgumentException("owner");
            }
            if (metaModel == null) {
                throw new IllegalArgumentException("metaModel");
            }
            if (StringUtils.isEmpty((String)this._alias)) {
                throw new ValidationException(new RequiredAttributeError("Alias"));
            }
            MetaObject compType = owner.getMeta();
            PropertyTypeUsage propUsage = ((ComponentType)compType).tryGetPropertyUsage(this._alias);
            if (propUsage == null) {
                propUsage = ((ComponentType)compType).tryGetPropertyUsageByName(this._alias);
            }
            if (propUsage != null) {
                ExpectedPropertyBinding.Builder builder = new ExpectedPropertyBinding.Builder();
                builder.setPropertyUsage(propUsage).setValue(this.getValue());
                return builder.build(owner, metaModel);
            }
            PropertyType prop = metaModel.tryGetPropertyType(this._alias);
            if (prop != null) {
                ExtensionPropertyBinding.Builder builder = new ExtensionPropertyBinding.Builder();
                boolean isCCC = this._alias.startsWith("ccc");
                String alias = isCCC ? Utils.toFirstLowerCase(this._alias.substring(3)) : this._alias;
                builder.setAlias(alias).setProperty(prop).setValue(this.getValue());
                return builder.build(owner, metaModel);
            }
            throw new ValidationException(new ComponentUnresolvedPropertyBindingError(this._alias, owner.getId(), owner.getMeta().getLabel()));
        }
    }
}

