/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.Atom;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.PropertyTypeUsage;

public abstract class PropertyBinding
extends Atom {
    private final Component _owner;
    private final String _value;

    protected PropertyBinding(Builder builder, Component owner, MetaModel metaModel) throws ValidationException {
        assert (builder != null);
        assert (owner != null);
        assert (metaModel != null);
        this._owner = owner;
        this._value = StringUtils.defaultIfEmpty((String)builder._value, (String)"");
    }

    @Override
    public final String getKind() {
        return "PropertyBinding";
    }

    public abstract PropertyTypeUsage getPropertyUsage();

    public abstract String getAlias();

    public final String getValue() {
        return this._value;
    }

    public abstract String getInputType();

    public abstract PropertyType getProperty();

    public Component getOwner() {
        return this._owner;
    }

    public String getName() {
        return this.getProperty().getName();
    }

    public static abstract class Builder
    extends Atom.Builder {
        private String _value;

        public abstract String getAlias();

        public String getValue() {
            return this._value;
        }

        public Builder setValue(String value) {
            this._value = value;
            return this;
        }

        public abstract PropertyBinding build(Component var1, MetaModel var2) throws ValidationException;
    }
}

