/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.DashboardCacheKey;
import pt.webdetails.cdf.dd.MetaModelManager;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.reader.IThingReader;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsReadContext;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsThingReaderFactory;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.CdfRunJsThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriter;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.render.DependenciesManager;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;

public final class DashboardManager {
    private static final Log _logger = LogFactory.getLog(DashboardManager.class);
    private static final DashboardManager _instance = new DashboardManager();
    private static final String CACHE_CFG_FILE = "ehcache.xml";
    private static final String CACHE_NAME = "pentaho-cde";
    private final CacheManager _ehCacheManager = DashboardManager.createWriteResultCacheManager();
    private final Cache _ehCache;
    private final Object _ehCacheLock;
    private final Map<String, Dashboard> _dashboardsByCdfdeFilePath;

    private DashboardManager() {
        if (!this._ehCacheManager.cacheExists(CACHE_NAME)) {
            this._ehCacheManager.addCache(CACHE_NAME);
        }
        this._ehCache = this._ehCacheManager.getCache(CACHE_NAME);
        this._ehCacheLock = new Object();
        this._dashboardsByCdfdeFilePath = new HashMap<String, Dashboard>();
    }

    public static DashboardManager getInstance() {
        return _instance;
    }

    public CdfRunJsDashboardWriteResult getDashboardCdfRunJs(String wcdfFilePath, CdfRunJsDashboardWriteOptions options, boolean bypassCacheRead) throws ThingWriteException {
        return this.getDashboardCdfRunJs(wcdfFilePath, options, bypassCacheRead, "");
    }

    public CdfRunJsDashboardWriteResult getDashboardCdfRunJs(String wcdfFilePath, CdfRunJsDashboardWriteOptions options, boolean bypassCacheRead, String style) throws ThingWriteException {
        DashboardWcdfDescriptor wcdf;
        if (wcdfFilePath == null) {
            throw new IllegalArgumentException("wcdfFilePath");
        }
        if (!wcdfFilePath.isEmpty() && wcdfFilePath.endsWith(".wcdf")) {
            try {
                wcdf = DashboardWcdfDescriptor.load(wcdfFilePath);
            }
            catch (IOException ex) {
                throw new ThingWriteException("While accessing the WCDF file.", ex);
            }
            if (wcdf == null) {
                wcdf = new DashboardWcdfDescriptor();
            }
        } else {
            wcdf = this.getPreviewWcdf(wcdfFilePath);
            bypassCacheRead = true;
        }
        if (StringUtils.isNotEmpty((String)style)) {
            wcdf.setStyle(style);
        }
        return this.getDashboardCdfRunJs(wcdf, options, bypassCacheRead);
    }

    public DashboardWcdfDescriptor getPreviewWcdf(String cdfdePath) throws ThingWriteException {
        DashboardWcdfDescriptor wcdf = new DashboardWcdfDescriptor();
        if (!cdfdePath.isEmpty() && cdfdePath.endsWith(".cdfde")) {
            wcdf.setPath(cdfdePath);
        }
        wcdf.setStyle("Clean");
        wcdf.setRendererType(DashboardWcdfDescriptor.DashboardRendererType.BLUEPRINT.getType());
        return wcdf;
    }

    public CdfRunJsDashboardWriteResult getDashboardCdfRunJs(DashboardWcdfDescriptor wcdf, CdfRunJsDashboardWriteOptions options, boolean bypassCacheRead) throws ThingWriteException {
        Dashboard dash;
        CdfRunJsDashboardWriteResult dashWrite;
        String cdeFilePath = Utils.sanitizeSlashesInPath(wcdf.getStructurePath());
        DashboardCacheKey cacheKey = new DashboardCacheKey(cdeFilePath, CdeEnvironment.getPluginResourceLocationManager().getStyleResourceLocation(wcdf.getStyle()), options.isDebug(), options.isAbsolute(), options.getSchemedRoot(), options.getAliasPrefix());
        if (!Utils.getSystemOrUserReadAccess(wcdf.getPath()).fileExists(cdeFilePath)) {
            throw new ThingWriteException(new FileNotFoundException(cdeFilePath));
        }
        if (!bypassCacheRead) {
            try {
                dashWrite = this.getDashboardWriteResultFromCache(cacheKey, cdeFilePath);
            }
            catch (FileNotFoundException ex) {
                throw new ThingWriteException(ex);
            }
            if (dashWrite != null) {
                return dashWrite;
            }
        } else {
            _logger.info((Object)"Bypassing dashboard render cache, rendering.");
        }
        try {
            dash = this.getDashboard(wcdf, cdeFilePath, bypassCacheRead);
        }
        catch (ThingReadException ex) {
            throw new ThingWriteException(ex);
        }
        dashWrite = this.writeDashboardToCdfRunJs(dash, options, bypassCacheRead);
        return this.replaceDashboardWriteResultInCache(cacheKey, dashWrite);
    }

    public Dashboard getDashboard(String wcdfPath, boolean bypassCacheRead) throws ThingReadException {
        try {
            DashboardWcdfDescriptor wcdf = DashboardWcdfDescriptor.load(wcdfPath);
            if (wcdf == null) {
                throw new ThingReadException(new FileNotFoundException(wcdfPath));
            }
            return this.getDashboard(wcdf, bypassCacheRead);
        }
        catch (IOException ex) {
            throw new ThingReadException("While reading dashboard.", ex);
        }
    }

    public Dashboard getDashboard(DashboardWcdfDescriptor wcdf, boolean bypassCacheRead) throws ThingReadException {
        String cdeFilePath = Utils.sanitizeSlashesInPath(wcdf.getStructurePath());
        IBasicFile cdeFile = Utils.getSystemOrUserReadAccess(cdeFilePath).fetchFile(cdeFilePath);
        if (cdeFile == null) {
            throw new ThingReadException(new FileNotFoundException(cdeFilePath));
        }
        return this.getDashboard(wcdf, cdeFilePath, bypassCacheRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDashboard(String wcdfPath) {
        HashMap<String, Dashboard> dashboardsByCdfdeFilePath;
        String cdeFilePath = Utils.sanitizeSlashesInPath(DashboardWcdfDescriptor.toStructurePath(wcdfPath));
        Map<String, Dashboard> map = this._dashboardsByCdfdeFilePath;
        synchronized (map) {
            dashboardsByCdfdeFilePath = new HashMap<String, Dashboard>(this._dashboardsByCdfdeFilePath);
        }
        HashSet<String> invalidateDashboards = new HashSet<String>();
        invalidateDashboards.add(cdeFilePath);
        Dashboard dash = (Dashboard)dashboardsByCdfdeFilePath.get(cdeFilePath);
        if (dash != null && dash.getWcdf().isWidget()) {
            this.collectWidgetsToInvalidate(invalidateDashboards, dashboardsByCdfdeFilePath, cdeFilePath);
        }
        if (_logger.isDebugEnabled()) {
            for (String invalidCdeFilePath : invalidateDashboards) {
                _logger.debug((Object)("Invalidating cache of dashboard '" + invalidCdeFilePath + "'."));
            }
        }
        Object object = this._dashboardsByCdfdeFilePath;
        synchronized (object) {
            for (String invalidCdeFilePath : invalidateDashboards) {
                this._dashboardsByCdfdeFilePath.remove(invalidCdeFilePath);
            }
        }
        object = this._ehCacheLock;
        synchronized (object) {
            List ehKeys = this._ehCache.getKeys();
            for (DashboardCacheKey ehKey : ehKeys) {
                if (!invalidateDashboards.contains(ehKey.getCdfde())) continue;
                this._ehCache.remove((Serializable)ehKey);
            }
        }
    }

    public void refreshAll() {
        this.refreshAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAll(boolean refreshDatasources) {
        MetaModelManager.getInstance().refresh(refreshDatasources);
        DependenciesManager.refresh();
        Object object = this._dashboardsByCdfdeFilePath;
        synchronized (object) {
            this._dashboardsByCdfdeFilePath.clear();
        }
        object = this._ehCacheLock;
        synchronized (object) {
            this._ehCache.removeAll();
        }
    }

    private void collectWidgetsToInvalidate(Set<String> invalidateDashboards, Map<String, Dashboard> dashboardsByCdfdeFilePath, String cdeWidgetFilePath) {
        block0: for (Dashboard dash : dashboardsByCdfdeFilePath.values()) {
            String cdeDashFilePath = dash.getSourcePath();
            if (invalidateDashboards.contains(cdeDashFilePath)) continue;
            Iterable<Component> comps = dash.getRegulars();
            for (Component comp : comps) {
                WidgetComponent widgetComp;
                if (!(comp instanceof WidgetComponent) || !DashboardWcdfDescriptor.toStructurePath((widgetComp = (WidgetComponent)comp).getWcdfPath()).equals(cdeWidgetFilePath)) continue;
                invalidateDashboards.add(cdeDashFilePath);
                if (!dash.getWcdf().isWidget()) continue block0;
                this.collectWidgetsToInvalidate(invalidateDashboards, dashboardsByCdfdeFilePath, cdeDashFilePath);
                continue block0;
            }
        }
    }

    private Dashboard getDashboard(DashboardWcdfDescriptor wcdf, String cdeFilePath, boolean bypassCacheRead) throws ThingReadException {
        Dashboard cachedDash = null;
        if (!bypassCacheRead) {
            cachedDash = this.getDashboardFromCache(cdeFilePath);
            if (cachedDash == null) {
                _logger.debug((Object)"Dashboard instance is not in cache, reading from repository.");
            }
        } else {
            _logger.info((Object)"Bypassing Dashboard instance cache, reading from repository.");
        }
        IReadAccess userAccess = Utils.getSystemOrUserReadAccess(cdeFilePath);
        if (cachedDash != null && cachedDash.getSourceDate().getTime() >= userAccess.getLastModified(cdeFilePath)) {
            if (!userAccess.fileExists(wcdf.getPath())) {
                throw new ThingReadException(new FileNotFoundException(wcdf.getPath()));
            }
            if (cachedDash.getSourceDate().getTime() >= userAccess.getLastModified(wcdf.getPath())) {
                _logger.debug((Object)"Cached Dashboard instance is valid, using it.");
                return cachedDash;
            }
        }
        if (cachedDash != null) {
            _logger.info((Object)"Cached Dashboard instance invalidated, reading from repository.");
        }
        Dashboard newDash = this.readDashboardFromCdfdeJs(wcdf);
        return this.replaceDashboardInCache(cdeFilePath, newDash, cachedDash);
    }

    private Dashboard readDashboardFromCdfdeJs(DashboardWcdfDescriptor wcdf) throws ThingReadException {
        IThingReader reader;
        JXPathContext cdfdeDoc;
        String cdeFilePath = wcdf.getStructurePath();
        try {
            cdfdeDoc = DashboardManager.openDashboardAsJXPathContext(wcdf);
        }
        catch (FileNotFoundException ex) {
            throw new ThingReadException("The CDFDE dashboard file does not exist.", ex);
        }
        catch (IOException ex) {
            throw new ThingReadException("While accessing the CDFDE dashboard file.", ex);
        }
        MetaModel metaModel = MetaModelManager.getInstance().getModel();
        CdfdeJsThingReaderFactory thingReaderFactory = new CdfdeJsThingReaderFactory(metaModel);
        try {
            reader = thingReaderFactory.getReader("Dashboard", null, null);
        }
        catch (UnsupportedThingException ex) {
            throw new ThingReadException("While obtaining a reader for a dashboard.", ex);
        }
        CdfdeJsReadContext readContext = new CdfdeJsReadContext(thingReaderFactory, wcdf, metaModel);
        Dashboard.Builder dashBuilder = (Dashboard.Builder)reader.read(readContext, cdfdeDoc, cdeFilePath);
        try {
            return dashBuilder.build(metaModel);
        }
        catch (ValidationException ex) {
            throw new ThingReadException("While building the read dashboard.", ex);
        }
    }

    private CdfRunJsDashboardWriteResult writeDashboardToCdfRunJs(Dashboard dash, CdfRunJsDashboardWriteOptions options, boolean bypassCacheRead) throws ThingWriteException {
        CdfRunJsThingWriterFactory writerFactory = new CdfRunJsThingWriterFactory();
        CdfRunJsDashboardWriter writer = writerFactory.getDashboardWriter(dash);
        CdfRunJsDashboardWriteContext writeContext = CdeEngine.getInstance().getEnvironment().getCdfRunJsDashboardWriteContext(writerFactory, "", bypassCacheRead, dash, options);
        CdfRunJsDashboardWriteResult.Builder dashboardWriteBuilder = new CdfRunJsDashboardWriteResult.Builder();
        writer.write(dashboardWriteBuilder, writeContext, dash);
        return dashboardWriteBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CdfRunJsDashboardWriteResult getDashboardWriteResultFromCache(DashboardCacheKey cacheKey, String cdeFilePath) throws FileNotFoundException {
        boolean cacheInvalid;
        Element cacheElement;
        IReadAccess userContentAccess = Utils.getSystemOrUserReadAccess(cdeFilePath);
        try {
            Object object = this._ehCacheLock;
            synchronized (object) {
                cacheElement = this._ehCache.get((Serializable)cacheKey);
            }
        }
        catch (CacheException ex) {
            _logger.info((Object)"Cached dashboard render invalidated, re-rendering.");
            return null;
        }
        if (cacheElement == null) {
            _logger.debug((Object)"Dashboard render is not in cache.");
            return null;
        }
        CdfRunJsDashboardWriteResult dashWrite = (CdfRunJsDashboardWriteResult)cacheElement.getValue();
        String templPath = cacheKey.getTemplate();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 1);
        Date dashLoadedDate = dashWrite.getLoadedDate();
        boolean cacheExpired = cal.getTime().after(dashLoadedDate);
        if (cacheExpired) {
            _logger.debug((Object)"Cached dashboard render expired, re-rendering.");
            return null;
        }
        boolean bl = cacheInvalid = userContentAccess.getLastModified(cdeFilePath) > dashLoadedDate.getTime() || userContentAccess.fileExists(templPath) && userContentAccess.getLastModified(templPath) > dashLoadedDate.getTime();
        if (cacheInvalid) {
            _logger.info((Object)"Cached dashboard render invalidated, re-rendering.");
            return null;
        }
        _logger.info((Object)"Cached dashboard render is valid, using it.");
        return dashWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CdfRunJsDashboardWriteResult replaceDashboardWriteResultInCache(DashboardCacheKey cacheKey, CdfRunJsDashboardWriteResult newDashWrite) {
        Object object = this._ehCacheLock;
        synchronized (object) {
            CdfRunJsDashboardWriteResult currDashWrite;
            Element cacheElement;
            try {
                cacheElement = this._ehCache.get((Serializable)cacheKey);
            }
            catch (CacheException ex) {
                cacheElement = null;
            }
            if (cacheElement != null && (currDashWrite = (CdfRunJsDashboardWriteResult)cacheElement.getValue()).getLoadedDate().getTime() > newDashWrite.getLoadedDate().getTime()) {
                return currDashWrite;
            }
            try {
                this._ehCache.put(new Element((Serializable)cacheKey, (Serializable)newDashWrite));
            }
            catch (Exception cnfe) {
                _logger.warn((Object)"Class not found for cache key while writing to cache.", (Throwable)cnfe);
            }
            return newDashWrite;
        }
    }

    private static CacheManager createWriteResultCacheManager() throws CacheException {
        String cacheConfigFile = CACHE_CFG_FILE;
        IBasicFile cfgFile = CdeEnvironment.getPluginSystemReader().fetchFile(cacheConfigFile);
        CacheManager cacheMgr = new CacheManager(cfgFile != null ? cfgFile.getFullPath() : null);
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        return cacheMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dashboard getDashboardFromCache(String cdeFullPath) {
        Map<String, Dashboard> map = this._dashboardsByCdfdeFilePath;
        synchronized (map) {
            return this._dashboardsByCdfdeFilePath.get(cdeFullPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dashboard replaceDashboardInCache(String cdeFullPath, Dashboard newDash, Dashboard oldDash) {
        assert (newDash != null);
        Map<String, Dashboard> map = this._dashboardsByCdfdeFilePath;
        synchronized (map) {
            Dashboard currDash;
            if (oldDash != null && (currDash = this._dashboardsByCdfdeFilePath.get(cdeFullPath)) != null && currDash != oldDash) {
                return currDash;
            }
            this._dashboardsByCdfdeFilePath.put(cdeFullPath, newDash);
            return newDash;
        }
    }

    public static JXPathContext openDashboardAsJXPathContext(DashboardWcdfDescriptor wcdf) throws IOException, FileNotFoundException {
        return DashboardManager.openDashboardAsJXPathContext(wcdf.getStructurePath(), wcdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JXPathContext openDashboardAsJXPathContext(String dashboardLocation, DashboardWcdfDescriptor wcdf) throws IOException, FileNotFoundException {
        JXPathContext jXPathContext;
        InputStream input = null;
        try {
            input = Utils.getSystemOrUserReadAccess(dashboardLocation).getFileInputStream(dashboardLocation);
            JSONObject json = (JSONObject)JsonUtils.readJsonFromInputStream(input);
            if (wcdf != null) {
                json.put((Object)"settings", (Object)wcdf.toJSON());
            }
            jXPathContext = JXPathContext.newContext((Object)json);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return jXPathContext;
    }
}

