/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.values;

import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSRawValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CSSCompoundAttrFunction
extends CSSFunctionValue {
    private String namespace;
    private String name;
    private String type;
    private String key;

    public CSSCompoundAttrFunction(String key, String namespace, String name, String type) {
        super("-x-pentaho-css-attr", CSSCompoundAttrFunction.produceParameters(key, namespace, name, type));
        this.namespace = namespace;
        this.name = name;
        this.type = type;
        this.key = key;
    }

    public CSSCompoundAttrFunction(String key, String namespace, String name) {
        this(key, namespace, name, null);
    }

    private static CSSValue[] produceParameters(String key, String namespace, String name, String type) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        CSSConstant nameConst = namespace == null ? new CSSConstant("") : new CSSConstant(namespace);
        if (type == null) {
            return new CSSValue[]{new CSSRawValue(key), nameConst, new CSSConstant(name)};
        }
        return new CSSValue[]{new CSSRawValue(key), nameConst, new CSSConstant(name), new CSSConstant(type)};
    }

    public String getName() {
        return this.name;
    }

    public String getValueType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getCSSText() {
        if (this.type != null) {
            if (this.namespace == null) {
                return "-x-pentaho-css-attr(|" + this.name + ", " + this.type + ')';
            }
            return "-x-pentaho-css-attr(" + this.namespace + '|' + this.name + ", " + this.type + ')';
        }
        if (this.namespace == null) {
            return "attr(|" + this.name + ')';
        }
        return "attr(" + this.namespace + '|' + this.name + ')';
    }
}

