/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.values;

import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CSSAttrFunction
extends CSSFunctionValue {
    private String namespace;
    private String name;
    private String type;

    public CSSAttrFunction(String namespace, String name, String type) {
        super("attr", CSSAttrFunction.produceParameters(namespace, name, type));
        this.namespace = namespace;
        this.name = name;
        this.type = type;
    }

    public CSSAttrFunction(String namespace, String name) {
        this(namespace, name, null);
    }

    private static CSSValue[] produceParameters(String namespace, String name, String type) {
        if (name == null) {
            throw new NullPointerException();
        }
        CSSConstant nameConst = namespace == null ? new CSSConstant("") : new CSSConstant(namespace);
        if (type == null) {
            return new CSSValue[]{nameConst, new CSSConstant(name)};
        }
        return new CSSValue[]{nameConst, new CSSConstant(name), new CSSConstant(type)};
    }

    public String getName() {
        return this.name;
    }

    public String getValueType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getCSSText() {
        if (this.type != null) {
            if (this.namespace == null) {
                return "attr(|" + this.name + ", " + this.type + ")";
            }
            return "attr(" + this.namespace + "|" + this.name + ", " + this.type + ")";
        }
        if (this.namespace == null) {
            return "attr(|" + this.name + ")";
        }
        return "attr(" + this.namespace + "|" + this.name + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CSSAttrFunction && super.equals(obj)) {
            CSSAttrFunction that = (CSSAttrFunction)obj;
            return ObjectUtilities.equal((Object)this.name, (Object)that.name) && ObjectUtilities.equal((Object)this.namespace, (Object)that.namespace) && ObjectUtilities.equal((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

