/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.pentaho.reporting.libraries.css.keys.color.CSSSystemColors;
import org.pentaho.reporting.libraries.css.keys.color.HtmlColors;
import org.pentaho.reporting.libraries.css.keys.color.SVGColors;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public final class ColorUtil {
    private static final HashMap knownColorNamesByColor = new HashMap();
    private static final HashMap knownColorsByName = new HashMap();
    private static final float ONE_THIRD = 0.33333334f;

    private static void fillColorsFromClass(Class c) {
        try {
            Field[] fields = c.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                Object oColor = f.get(null);
                if (!(oColor instanceof CSSColorValue)) continue;
                knownColorNamesByColor.put(oColor, name.toLowerCase());
                knownColorsByName.put(name.toLowerCase(), oColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ColorUtil() {
    }

    public static float[] hslToRGB(int h, float s, float l) {
        float lightness;
        int hue = ColorUtil.normalizeHue(h);
        float saturation = s;
        if (saturation > 100.0f) {
            saturation = 100.0f;
        }
        if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if ((lightness = l) > 100.0f) {
            lightness = 100.0f;
        }
        if (lightness < 0.0f) {
            lightness = 0.0f;
        }
        float m2 = (double)lightness <= 0.5 ? lightness * (saturation + 1.0f) : lightness + saturation - lightness * saturation;
        float m1 = lightness * 2.0f - m2;
        float r = ColorUtil.hueToRGB(m1, m2, (float)hue + 0.33333334f);
        float g = ColorUtil.hueToRGB(m1, m2, hue);
        float b = ColorUtil.hueToRGB(m1, m2, (float)hue - 0.33333334f);
        return new float[]{r, g, b};
    }

    private static float hueToRGB(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return m1 + (m2 - m1) * h * 6.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2;
        }
        if (h * 3.0f < 2.0f) {
            return m1 + (m2 - m1) * (0.6666667f - h) * 6.0f;
        }
        return m1;
    }

    private static int normalizeHue(int integerValue) {
        return (integerValue % 360 + 360) % 360;
    }

    public static CSSValue parseColor(String colorSpec) {
        CSSValue color = ColorUtil.parseIdentColor(colorSpec);
        if (color != null) {
            return color;
        }
        try {
            if (colorSpec.length() == 4) {
                int redColorValue = ColorUtil.charToNumber(colorSpec.charAt(1));
                int greenColorValue = ColorUtil.charToNumber(colorSpec.charAt(2));
                int blueColorValue = ColorUtil.charToNumber(colorSpec.charAt(3));
                int colorValue = redColorValue << 20 | redColorValue << 16 | greenColorValue << 12 | greenColorValue << 8 | blueColorValue << 4 | blueColorValue;
                return new CSSColorValue(colorValue, false);
            }
            Integer decoded = Integer.decode(colorSpec);
            return new CSSColorValue(decoded, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int charToNumber(char character) {
        switch (character) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'a': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'b': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'c': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'd': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'e': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'f': {
                return 15;
            }
        }
        throw new NullPointerException();
    }

    public static CSSValue parseIdentColor(String name) {
        if (CSSSystemColors.CURRENT_COLOR.getCSSText().equalsIgnoreCase(name)) {
            return CSSSystemColors.CURRENT_COLOR;
        }
        return (CSSValue)knownColorsByName.get(name.toLowerCase());
    }

    static {
        ColorUtil.fillColorsFromClass(SVGColors.class);
        ColorUtil.fillColorsFromClass(HtmlColors.class);
        ColorUtil.fillColorsFromClass(CSSSystemColors.class);
    }
}

