/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.percentages.text;

import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public class WordSpacingResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        FontMetrics fm = process.getOutputMetaData().getFontMetrics(layoutContext);
        if (fm == null) {
            CSSValue value = layoutContext.getValue(FontStyleKeys.FONT_FAMILY);
            DebugLog.log((Object)("FontFamily is " + value + " but has not been set?" + currentNode));
            return;
        }
        double width = FontStrictGeomUtility.toExternalValue((long)fm.getCharWidth(32));
        CSSNumericValue percentageBase = CSSNumericValue.createValue(CSSNumericType.PT, width);
        CSSNumericValue min = StyleSheetUtility.convertLength(this.resolveValue(layoutContext, TextStyleKeys.X_MIN_WORD_SPACING), percentageBase, currentNode);
        CSSNumericValue max = StyleSheetUtility.convertLength(this.resolveValue(layoutContext, TextStyleKeys.X_MAX_WORD_SPACING), percentageBase, currentNode);
        CSSNumericValue opt = StyleSheetUtility.convertLength(this.resolveValue(layoutContext, TextStyleKeys.X_OPTIMUM_WORD_SPACING), percentageBase, currentNode);
        layoutContext.setValue(TextStyleKeys.X_MIN_WORD_SPACING, min);
        layoutContext.setValue(TextStyleKeys.X_MAX_WORD_SPACING, max);
        layoutContext.setValue(TextStyleKeys.X_OPTIMUM_WORD_SPACING, opt);
    }

    private CSSNumericValue resolveValue(LayoutStyle style, StyleKey key) {
        CSSValue value = style.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        return (CSSNumericValue)value;
    }
}

