/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.text;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.keys.border.BorderWidth;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.text.TextDecorationWidth;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class TextDecorationWidthResolveHandler
extends ConstantsResolveHandler {
    public TextDecorationWidthResolveHandler() {
        this.addValue(BorderWidth.THIN, CSSNumericValue.createValue(CSSNumericType.PT, 0.5));
        this.addValue(BorderWidth.MEDIUM, CSSNumericValue.createValue(CSSNumericType.PT, 1.0));
        this.addValue(BorderWidth.THICK, CSSNumericValue.createValue(CSSNumericType.PT, 1.5));
        this.addValue(TextDecorationWidth.DASH, CSSNumericValue.createValue(CSSNumericType.PT, 0.75));
        this.addValue(TextDecorationWidth.BOLD, CSSNumericValue.createValue(CSSNumericType.PT, 1.25));
        this.setFallback(CSSNumericValue.ZERO_LENGTH);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    @Override
    protected CSSValue resolveValue(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = currentNode.getLayoutStyle().getValue(key);
        if (value instanceof CSSConstant) {
            return super.resolveValue(process, currentNode, key);
        }
        return value;
    }
}

