/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.page;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.page.PageSize;
import org.pentaho.reporting.libraries.css.keys.page.PageSizeFactory;
import org.pentaho.reporting.libraries.css.keys.page.PageStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;

public class PageSizeResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];

    @Override
    public StyleKey[] getRequiredStyles() {
        return EMPTY_KEYS;
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(PageStyleKeys.SIZE);
        String name = null;
        if (value instanceof CSSStringValue) {
            CSSStringValue sval = (CSSStringValue)value;
            name = sval.getValue();
        } else if (value instanceof CSSConstant) {
            name = value.toString();
        }
        PageSize ps = null;
        if (name != null) {
            ps = PageSizeFactory.getInstance().getPageSizeByName(name);
        }
        if (ps == null) {
            ps = process.getOutputMetaData().getDefaultPageSize();
        }
        CSSValuePair page = new CSSValuePair(CSSNumericValue.createPtValue(ps.getWidth()), CSSNumericValue.createPtValue(ps.getHeight()));
        layoutContext.setValue(PageStyleKeys.SIZE, page);
    }
}

