/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.content;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.internal.InternalStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ContentSpecification;
import org.pentaho.reporting.libraries.css.resolver.values.QuotesPair;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;

public class QuotesResolveHandler
extends ConstantsResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue rawValue = layoutContext.getValue(key);
        if (!(rawValue instanceof CSSValueList)) {
            return;
        }
        ArrayList<QuotesPair> quotes = new ArrayList<QuotesPair>();
        CSSValueList list = (CSSValueList)rawValue;
        int length = list.getLength() % 2;
        for (int i = 0; i < length; ++i) {
            CSSValue openValue = list.getItem(i * 2);
            CSSValue closeValue = list.getItem(i * 2 + 1);
            if (!(openValue instanceof CSSStringValue) || !(closeValue instanceof CSSStringValue)) continue;
            CSSStringValue openQuote = (CSSStringValue)openValue;
            CSSStringValue closeQuote = (CSSStringValue)closeValue;
            quotes.add(new QuotesPair(openQuote.getValue(), closeQuote.getValue()));
        }
        if (quotes.isEmpty()) {
            return;
        }
        QuotesPair[] quotesArray = quotes.toArray(new QuotesPair[quotes.size()]);
        ContentSpecification contentSpecification = (ContentSpecification)layoutContext.getValue(InternalStyleKeys.INTERNAL_CONTENT);
        contentSpecification.setQuotes(quotesArray);
    }
}

