/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.libraries.css.PageAreaType;
import org.pentaho.reporting.libraries.css.PseudoPage;
import org.pentaho.reporting.libraries.css.dom.DefaultLayoutStyle;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.CSSPageAreaRule;
import org.pentaho.reporting.libraries.css.model.CSSPageRule;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.namespace.NamespaceCollection;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.css.parser.StyleSheetParserUtil;
import org.pentaho.reporting.libraries.css.resolver.StyleResolver;
import org.pentaho.reporting.libraries.css.resolver.StyleRuleMatcher;
import org.pentaho.reporting.libraries.css.resolver.impl.AbstractStyleResolver;
import org.pentaho.reporting.libraries.css.resolver.impl.CSSStyleRuleComparator;
import org.pentaho.reporting.libraries.css.resolver.impl.SimpleStyleRuleMatcher;
import org.pentaho.reporting.libraries.css.selectors.CSSSelector;
import org.pentaho.reporting.libraries.css.selectors.SelectorWeight;
import org.pentaho.reporting.libraries.css.values.CSSInheritValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultStyleResolver
extends AbstractStyleResolver {
    private boolean strictStyleMode;
    private StyleRuleMatcher styleRuleMatcher;
    private StyleKey[] inheritedKeys;

    @Override
    public void initialize(DocumentContext layoutProcess) {
        super.initialize(layoutProcess);
        this.styleRuleMatcher = new SimpleStyleRuleMatcher();
        this.styleRuleMatcher.initialize(layoutProcess);
        this.loadInitialStyle(layoutProcess);
    }

    @Override
    protected void resolveOutOfContext(LayoutElement element) {
        this.resolveStyle(element);
    }

    @Override
    public boolean isPseudoElementStyleResolvable(LayoutElement element, String pseudo) {
        return this.styleRuleMatcher.isMatchingPseudoElement(element, pseudo);
    }

    @Override
    public void resolveStyle(LayoutElement element) {
        StyleKey key;
        int i;
        StyleKey[] keys = this.getKeys();
        LayoutElement parent = element.getParentLayoutElement();
        LayoutStyle initialStyle = this.getInitialStyle();
        LayoutStyle style = element.getLayoutStyle();
        if (!style.copyFrom(initialStyle)) {
            for (int i2 = 0; i2 < keys.length; ++i2) {
                StyleKey key2 = keys[i2];
                style.setValue(key2, initialStyle.getValue(key2));
            }
        }
        if (parent != null) {
            LayoutStyle parentStyle = parent.getLayoutStyle();
            StyleKey[] inheritedKeys = this.getInheritedKeys();
            for (i = 0; i < inheritedKeys.length; ++i) {
                key = inheritedKeys[i];
                style.setValue(key, parentStyle.getValue(key));
            }
        }
        this.performSelectionStep(element, style);
        Object libLayoutStyleValue = element.getAttribute("http://jfreereport.sourceforge.net/namespaces/layout", "style");
        this.addStyleFromAttribute(element, libLayoutStyleValue);
        if (this.strictStyleMode) {
            this.performStrictStyleAttr(element);
        } else {
            this.performCompleteStyleAttr(element);
        }
        CSSInheritValue inheritInstance = CSSInheritValue.getInstance();
        if (parent == null) {
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                CSSValue value = style.getValue(key);
                if (!inheritInstance.equals(value)) continue;
                style.setValue(key, initialStyle.getValue(key));
            }
        } else {
            LayoutStyle parentStyle = parent.getLayoutStyle();
            for (int i3 = 0; i3 < keys.length; ++i3) {
                StyleKey key3 = keys[i3];
                CSSValue value = style.getValue(key3);
                if (!inheritInstance.equals(value)) continue;
                CSSValue parentValue = parentStyle.getValue(key3);
                if (parentValue == null) {
                    style.setValue(key3, initialStyle.getValue(key3));
                    continue;
                }
                style.setValue(key3, parentValue);
            }
        }
    }

    private StyleKey[] getInheritedKeys() {
        if (this.inheritedKeys == null) {
            StyleKey[] keys = this.getKeys();
            ArrayList<StyleKey> inheritedKeysList = new ArrayList<StyleKey>();
            for (int i = 0; i < keys.length; ++i) {
                StyleKey key = keys[i];
                if (!key.isInherited()) continue;
                inheritedKeysList.add(key);
            }
            this.inheritedKeys = inheritedKeysList.toArray(new StyleKey[inheritedKeysList.size()]);
        }
        return this.inheritedKeys;
    }

    private void performStrictStyleAttr(LayoutElement node) {
        String namespace = node.getNamespace();
        if (namespace == null) {
            return;
        }
        NamespaceCollection namespaces = this.getNamespaces();
        NamespaceDefinition ndef = namespaces.getDefinition(namespace);
        if (ndef == null) {
            return;
        }
        String[] styleAttrs = ndef.getStyleAttribute(node.getTagName());
        for (int i = 0; i < styleAttrs.length; ++i) {
            String attr = styleAttrs[i];
            Object styleValue = node.getAttribute(namespace, attr);
            this.addStyleFromAttribute(node, styleValue);
        }
    }

    private void performCompleteStyleAttr(LayoutElement node) {
        NamespaceCollection namespaces = this.getNamespaces();
        String[] namespaceNames = namespaces.getNamespaces();
        for (int i = 0; i < namespaceNames.length; ++i) {
            String namespace = namespaceNames[i];
            NamespaceDefinition ndef = namespaces.getDefinition(namespace);
            if (ndef == null) continue;
            String[] styleAttrs = ndef.getStyleAttribute(node.getTagName());
            for (int x = 0; x < styleAttrs.length; ++x) {
                String attr = styleAttrs[x];
                Object styleValue = node.getAttribute(namespace, attr);
                this.addStyleFromAttribute(node, styleValue);
            }
        }
    }

    private void addStyleFromAttribute(LayoutElement node, Object styleValue) {
        if (styleValue == null) {
            return;
        }
        if (styleValue instanceof String) {
            String styleText = (String)styleValue;
            ResourceManager resourceManager = this.getDocumentContext().getResourceManager();
            CSSDeclarationRule rule = StyleSheetParserUtil.getInstance().parseStyleRule(null, styleText, null, null, resourceManager, StyleKeyRegistry.getRegistry());
            if (rule != null) {
                this.copyStyleInformation(node.getLayoutStyle(), rule, node);
            }
        } else if (styleValue instanceof CSSDeclarationRule) {
            CSSDeclarationRule rule = (CSSDeclarationRule)styleValue;
            this.copyStyleInformation(node.getLayoutStyle(), rule, node);
        }
    }

    private void performSelectionStep(LayoutElement element, LayoutStyle parentStyle) {
        CSSStyleRule[] activeStyleRules = this.styleRuleMatcher.getMatchingRules(element);
        Arrays.sort(activeStyleRules, new CSSStyleRuleComparator());
        SelectorWeight oldSelectorWeight = null;
        for (int i = 0; i < activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = activeStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            SelectorWeight activeWeight = selector.getWeight();
            if (oldSelectorWeight != null && oldSelectorWeight.compareTo(activeWeight) > 0) {
                oldSelectorWeight = activeWeight;
                continue;
            }
            oldSelectorWeight = activeWeight;
            this.copyStyleInformation(parentStyle, activeStyleRule, element);
        }
    }

    @Override
    public StyleResolver deriveInstance() {
        return this;
    }

    @Override
    public LayoutStyle resolvePageStyle(CSSValue pageName, PseudoPage[] pseudoPages, PageAreaType pageArea) {
        DefaultLayoutStyle style = new DefaultLayoutStyle();
        CSSPageRule[] pageRule = this.styleRuleMatcher.getPageRule(pageName, pseudoPages);
        for (int i = 0; i < pageRule.length; ++i) {
            CSSPageRule cssPageRule = pageRule[i];
            this.copyStyleInformation(style, cssPageRule, null);
            int rc = cssPageRule.getRuleCount();
            for (int r = 0; r < rc; ++r) {
                CSSPageAreaRule rule = cssPageRule.getRule(r);
                if (!rule.getPageArea().equals(pageArea)) continue;
                this.copyStyleInformation(style, rule, null);
            }
        }
        return style;
    }
}

