/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.content;

import org.pentaho.reporting.libraries.css.counter.CounterStyle;
import org.pentaho.reporting.libraries.css.counter.CounterStyleFactory;
import org.pentaho.reporting.libraries.css.counter.numeric.DecimalCounterStyle;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.ContentFunction;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.tokens.ContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.CountersToken;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CountersValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException();
        }
        String counterName = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String separator = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        CounterStyle cstyle = null;
        if (params.length > 2) {
            String styleName = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
            cstyle = CounterStyleFactory.getInstance().getCounterStyle(styleName);
        }
        if (cstyle == null) {
            cstyle = new DecimalCounterStyle();
        }
        return new CountersToken(counterName, separator, cstyle);
    }
}

