/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.resolver.function.ContentFunction;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;

public final class FunctionFactory {
    public static final String VALUE_FUNCTIONS_KEY_RANGE = "org.pentaho.reporting.libraries.css.functions.values.";
    public static final String CONTENT_FUNCTIONS_KEY_RANGE = "org.pentaho.reporting.libraries.css.functions.content.";
    private HashMap styleFunctions = new HashMap();
    private HashMap contentFunctions = new HashMap();
    private static FunctionFactory instance;

    public static FunctionFactory getInstance() {
        if (instance == null) {
            instance = new FunctionFactory();
            instance.registerDefault();
        }
        return instance;
    }

    private FunctionFactory() {
    }

    public void registerDefault() {
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        Iterator valueKeys = config.findPropertyKeys(VALUE_FUNCTIONS_KEY_RANGE);
        while (valueKeys.hasNext()) {
            String key = (String)valueKeys.next();
            String value = config.getConfigProperty(key);
            String name = key.substring(VALUE_FUNCTIONS_KEY_RANGE.length());
            Object maybeFunction = ObjectUtilities.loadAndInstantiate((String)value, FunctionFactory.class, StyleValueFunction.class);
            if (!(maybeFunction instanceof StyleValueFunction)) continue;
            this.styleFunctions.put(name.toLowerCase(), maybeFunction);
        }
        Iterator contentKeys = config.findPropertyKeys(CONTENT_FUNCTIONS_KEY_RANGE);
        while (contentKeys.hasNext()) {
            String key = (String)contentKeys.next();
            String value = config.getConfigProperty(key);
            String name = key.substring(CONTENT_FUNCTIONS_KEY_RANGE.length());
            Object maybeFunction = ObjectUtilities.loadAndInstantiate((String)value, FunctionFactory.class, ContentFunction.class);
            if (!(maybeFunction instanceof ContentFunction)) continue;
            this.contentFunctions.put(name.toLowerCase(), maybeFunction);
        }
    }

    public StyleValueFunction getStyleFunction(String name) {
        StyleValueFunction function = (StyleValueFunction)this.styleFunctions.get(name.toLowerCase());
        if (function == null) {
            // empty if block
        }
        return function;
    }

    public ContentFunction getContentFunction(String name) {
        ContentFunction function = (ContentFunction)this.contentFunctions.get(name.toLowerCase());
        if (function == null) {
            // empty if block
        }
        return function;
    }
}

