/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.page;

import org.pentaho.reporting.libraries.css.keys.page.PageSize;
import org.pentaho.reporting.libraries.css.keys.page.PageSizeFactory;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.AbstractWidthReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class SizeReadHandler
extends AbstractWidthReadHandler
implements CSSValueReadHandler {
    public SizeReadHandler() {
        super(true, false);
    }

    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSNumericValue verticalWidth;
        if (value.getLexicalUnitType() == 35) {
            String ident = value.getStringValue();
            if (ident.equalsIgnoreCase("auto")) {
                return CSSAutoValue.getInstance();
            }
            PageSize ps = PageSizeFactory.getInstance().getPageSizeByName(ident);
            if (ps == null) {
                return null;
            }
            value = value.getNextLexicalUnit();
            int pageOrientation = 1;
            if (value != null) {
                if (value.getLexicalUnitType() != 35) {
                    return null;
                }
                if (value.getStringValue().equalsIgnoreCase("landscape")) {
                    pageOrientation = 0;
                } else if (value.getStringValue().equalsIgnoreCase("reverse-landscape")) {
                    pageOrientation = 2;
                } else if (value.getStringValue().equalsIgnoreCase("portrait")) {
                    pageOrientation = 1;
                } else {
                    return null;
                }
            }
            if (pageOrientation == 0 || pageOrientation == 2) {
                return new CSSValuePair(CSSNumericValue.createPtValue(ps.getHeight()), CSSNumericValue.createPtValue(ps.getWidth()));
            }
            return new CSSValuePair(CSSNumericValue.createPtValue(ps.getWidth()), CSSNumericValue.createPtValue(ps.getHeight()));
        }
        CSSNumericValue horizontalWidth = (CSSNumericValue)this.parseWidth(value);
        if (horizontalWidth == null) {
            return null;
        }
        if ((value = value.getNextLexicalUnit()) == null) {
            verticalWidth = horizontalWidth;
        } else {
            verticalWidth = (CSSNumericValue)this.parseWidth(value);
            if (verticalWidth == null) {
                return null;
            }
        }
        return new CSSValuePair(horizontalWidth, verticalWidth);
    }
}

