/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.line;

import org.pentaho.reporting.libraries.css.keys.line.LineHeight;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class LineHeightReadHandler
implements CSSValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            if (value.getStringValue().equalsIgnoreCase("none")) {
                return LineHeight.NONE;
            }
            if (value.getStringValue().equalsIgnoreCase("normal")) {
                return LineHeight.NORMAL;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        CSSNumericValue number = CSSValueFactory.createNumericValue(value);
        if (number != null) {
            return number;
        }
        return CSSValueFactory.createLengthValue(value);
    }
}

