/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.font;

import org.pentaho.reporting.libraries.css.keys.font.FontSizeConstant;
import org.pentaho.reporting.libraries.css.keys.font.RelativeFontSize;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.stylehandler.OneOfConstantsReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class FontSizeReadHandler
extends OneOfConstantsReadHandler {
    public FontSizeReadHandler() {
        this(false);
    }

    protected FontSizeReadHandler(boolean autoAllowed) {
        super(autoAllowed);
        this.addValue(FontSizeConstant.LARGE);
        this.addValue(FontSizeConstant.MEDIUM);
        this.addValue(FontSizeConstant.SMALL);
        this.addValue(FontSizeConstant.X_LARGE);
        this.addValue(FontSizeConstant.XX_LARGE);
        this.addValue(FontSizeConstant.X_SMALL);
        this.addValue(FontSizeConstant.XX_SMALL);
        this.addValue(RelativeFontSize.LARGER);
        this.addValue(RelativeFontSize.SMALLER);
    }

    @Override
    protected CSSValue lookupValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        CSSValue constant = super.lookupValue(value);
        if (constant != null) {
            return constant;
        }
        return CSSValueFactory.createLengthValue(value);
    }
}

