/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.font;

import org.pentaho.reporting.libraries.css.keys.font.FontFamilyValues;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.stylehandler.ListOfValuesReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class FontFamilyReadHandler
extends ListOfValuesReadHandler {
    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() == 35 && value.getStringValue().equalsIgnoreCase("none")) {
            return FontFamilyValues.NONE;
        }
        return super.createValue(name, value);
    }

    @Override
    protected CSSValue parseValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            if (value.getStringValue().equalsIgnoreCase("serif")) {
                return FontFamilyValues.SERIF;
            }
            if (value.getStringValue().equalsIgnoreCase("sans-serif")) {
                return FontFamilyValues.SANS_SERIF;
            }
            if (value.getStringValue().equalsIgnoreCase("fantasy")) {
                return FontFamilyValues.FANTASY;
            }
            if (value.getStringValue().equalsIgnoreCase("cursive")) {
                return FontFamilyValues.CURSIVE;
            }
            if (value.getStringValue().equalsIgnoreCase("monospace")) {
                return FontFamilyValues.MONOSPACE;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 36) {
            return new CSSStringValue(CSSStringType.STRING, value.getStringValue());
        }
        return null;
    }
}

