/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser;

import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.parser.CSSParserInstantiationException;
import org.pentaho.reporting.libraries.css.parser.FixNamespaceConditionFactory;
import org.pentaho.reporting.libraries.css.parser.FixNamespaceSelectorFactory;
import org.pentaho.reporting.libraries.css.selectors.CSSSelectorFactory;
import org.pentaho.reporting.libraries.css.selectors.conditions.CSSConditionFactory;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.helpers.ParserFactory;

public class CSSParserFactory {
    private static CSSParserFactory parserFactory;

    public static synchronized CSSParserFactory getInstance() {
        if (parserFactory == null) {
            parserFactory = new CSSParserFactory();
        }
        return parserFactory;
    }

    private CSSParserFactory() {
    }

    public Parser createCSSParser() throws CSSParserInstantiationException {
        Parser p;
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        String parserClass = config.getConfigProperty("org.pentaho.reporting.libraries.css.Parser");
        if (parserClass != null && (p = (Parser)ObjectUtilities.loadAndInstantiate((String)parserClass, CSSParserFactory.class, Parser.class)) != null) {
            p.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory()));
            p.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory()));
            return p;
        }
        try {
            p = new ParserFactory().makeParser();
            if (p == null) {
                return null;
            }
            p.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory()));
            p.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory()));
            return p;
        }
        catch (Exception e) {
            throw new CSSParserInstantiationException(e.getMessage(), e);
        }
    }
}

