/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.namespace;

import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.css.namespace.DefaultNamespaceDefinition;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class Namespaces {
    public static final String LIBLAYOUT_NAMESPACE = "http://jfreereport.sourceforge.net/namespaces/layout";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    private Namespaces() {
    }

    public static NamespaceDefinition[] createFromConfig(Configuration config, String prefix, ResourceManager resourceManager) {
        ArrayList<DefaultNamespaceDefinition> retvals = new ArrayList<DefaultNamespaceDefinition>();
        Iterator keys = config.findPropertyKeys(prefix);
        while (keys.hasNext()) {
            String trimmedUri;
            String key = (String)keys.next();
            if (!key.endsWith(".Uri")) continue;
            String nsPrefix = key.substring(0, key.length() - 3);
            String uri = config.getConfigProperty(key);
            if (uri == null || (trimmedUri = uri.trim()).length() == 0) continue;
            String classAttr = config.getConfigProperty(nsPrefix + "ClassAttr");
            String styleAttr = config.getConfigProperty(nsPrefix + "StyleAttr");
            String prefixAttr = config.getConfigProperty(nsPrefix + "Prefix");
            String defaultStyle = config.getConfigProperty(nsPrefix + "Default-Style");
            ResourceKey styleResourceKey = null;
            if (resourceManager != null) {
                try {
                    if (defaultStyle != null) {
                        styleResourceKey = resourceManager.createKey((Object)defaultStyle);
                    }
                }
                catch (ResourceException e) {
                    // empty catch block
                }
            }
            retvals.add(new DefaultNamespaceDefinition(trimmedUri, styleResourceKey, classAttr, styleAttr, prefixAttr));
        }
        return retvals.toArray(new NamespaceDefinition[retvals.size()]);
    }
}

