/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.haivvreo;

import com.linkedin.haivvreo.HaivvreoException;
import com.linkedin.haivvreo.SchemaResolutionProblem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HaivvreoUtils {
    private static final Log LOG = LogFactory.getLog(HaivvreoUtils.class);
    public static final String SCHEMA_LITERAL = "schema.literal";
    public static final String SCHEMA_URL = "schema.url";
    public static final String SCHEMA_NONE = "none";
    public static final String EXCEPTION_MESSAGE = "Neither schema.literal nor schema.url specified, can't determine table schema";

    HaivvreoUtils() {
    }

    public static Schema determineSchemaOrThrowException(Properties properties) throws IOException, HaivvreoException {
        String schemaString = properties.getProperty(SCHEMA_LITERAL);
        if (schemaString != null && !schemaString.equals(SCHEMA_NONE)) {
            return Schema.parse((String)schemaString);
        }
        schemaString = properties.getProperty(SCHEMA_URL);
        if (schemaString == null || schemaString.equals(SCHEMA_NONE)) {
            throw new HaivvreoException(EXCEPTION_MESSAGE);
        }
        try {
            if (schemaString.toLowerCase().startsWith("hdfs://")) {
                return HaivvreoUtils.getSchemaFromHDFS(schemaString, new Configuration());
            }
        }
        catch (IOException ioe) {
            throw new HaivvreoException("Unable to read schema from HDFS: " + schemaString, ioe);
        }
        return Schema.parse((InputStream)new URL(schemaString).openStream());
    }

    public static Schema determineSchemaOrReturnErrorSchema(Properties props) {
        try {
            return HaivvreoUtils.determineSchemaOrThrowException(props);
        }
        catch (HaivvreoException he) {
            LOG.warn((Object)"Encountered HaivvreoException determing schema. Returning signal schema to indicate problem", (Throwable)((Object)he));
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
        catch (Exception e) {
            LOG.warn((Object)"Encountered exception determing schema. Returning signal schema to indicate problem", (Throwable)e);
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema getSchemaFromHDFS(String schemaHDFSUrl, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataInputStream in = null;
        try {
            Schema s;
            in = fs.open(new Path(schemaHDFSUrl));
            Schema schema = s = Schema.parse((InputStream)in);
            return schema;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean isNullableType(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    public static Schema getOtherTypeFromNullableType(Schema schema) {
        List types = schema.getTypes();
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }
}

