/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.haivvreo;

import com.linkedin.haivvreo.AvroDeserializer;
import com.linkedin.haivvreo.AvroGenericRecordWritable;
import com.linkedin.haivvreo.AvroObjectInspectorGenerator;
import com.linkedin.haivvreo.AvroSerializer;
import com.linkedin.haivvreo.BadSchemaException;
import com.linkedin.haivvreo.HaivvreoUtils;
import com.linkedin.haivvreo.SchemaResolutionProblem;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Writable;

public class AvroSerDe
implements SerDe {
    public static final String HAIVVREO_SCHEMA = "haivvreo.schema";
    private ObjectInspector oi;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private Schema schema;
    private AvroDeserializer avroDeserializer = null;
    private AvroSerializer avroSerializer = null;
    private boolean badSchema = false;

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        this.schema = null;
        this.oi = null;
        this.columnNames = null;
        this.columnTypes = null;
        this.schema = HaivvreoUtils.determineSchemaOrReturnErrorSchema(properties);
        if (configuration != null) {
            configuration.set(HAIVVREO_SCHEMA, this.schema.toString(false));
            configuration.set("hive.output.file.extension", ".avro");
        }
        this.badSchema = this.schema.equals((Object)SchemaResolutionProblem.SIGNAL_BAD_SCHEMA);
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator(this.schema);
        this.columnNames = aoig.getColumnNames();
        this.columnTypes = aoig.getColumnTypes();
        this.oi = aoig.getObjectInspector();
    }

    public Class<? extends Writable> getSerializedClass() {
        return AvroGenericRecordWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getSerializer().serialize(o, objectInspector, this.columnNames, this.columnTypes, this.schema);
    }

    public Object deserialize(Writable writable) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getDeserializer().deserialize(this.columnNames, this.columnTypes, writable, this.schema);
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.oi;
    }

    private AvroDeserializer getDeserializer() {
        if (this.avroDeserializer == null) {
            this.avroDeserializer = new AvroDeserializer();
        }
        return this.avroDeserializer;
    }

    private AvroSerializer getSerializer() {
        if (this.avroSerializer == null) {
            this.avroSerializer = new AvroSerializer();
        }
        return this.avroSerializer;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

