/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.haivvreo;

import com.linkedin.haivvreo.AvroGenericRecordWritable;
import com.linkedin.haivvreo.AvroGenericRecordWriter;
import com.linkedin.haivvreo.HaivvreoException;
import com.linkedin.haivvreo.HaivvreoUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;

public class AvroContainerOutputFormat
implements HiveOutputFormat<LongWritable, AvroGenericRecordWritable> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties properties, Progressable progressable) throws IOException {
        Schema schema;
        try {
            schema = HaivvreoUtils.determineSchemaOrThrowException(properties);
        }
        catch (HaivvreoException e) {
            throw new IOException((Throwable)((Object)e));
        }
        GenericDatumWriter gdw = new GenericDatumWriter(schema);
        DataFileWriter dfw = new DataFileWriter((DatumWriter)gdw);
        if (isCompressed) {
            int level = jobConf.getInt("avro.mapred.deflate.level", 1);
            String codecName = jobConf.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            dfw.setCodec(factory);
        }
        dfw.create(schema, (OutputStream)path.getFileSystem((Configuration)jobConf).create(path));
        return new AvroGenericRecordWriter((DataFileWriter<GenericRecord>)dfw);
    }
}

