/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formatting;

import java.util.ArrayList;
import java.util.Locale;
import org.pentaho.reporting.libraries.formatting.DummyFieldPosition;
import org.pentaho.reporting.libraries.formatting.FastChoiceFormat;
import org.pentaho.reporting.libraries.formatting.FastDateFormat;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;
import org.pentaho.reporting.libraries.formatting.FastFormat;

public class FastMessageFormat
implements FastFormat {
    private String pattern;
    private Locale locale;
    private FastFormat[] subFormats;
    private String[] constantTexts;
    private int[] argumentMapping;
    private int sizeHint;
    private String nullString;
    private transient StringBuffer buffer;
    private DummyFieldPosition fieldPosition;

    public FastMessageFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public FastMessageFormat(String pattern, Locale locale) {
        int i;
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.locale = locale;
        this.nullString = "<null>";
        String[] arguments = new String[3];
        int argumentIndex = 0;
        int stackDepth = 0;
        boolean escape = false;
        ArrayList<String> constants = new ArrayList<String>();
        ArrayList<FastFormat> patterns = new ArrayList<FastFormat>();
        ArrayList<Integer> indexMappings = new ArrayList<Integer>();
        StringBuilder b = new StringBuilder(pattern.length());
        char[] chars = this.pattern.toCharArray();
        block8: for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escape) {
                b.append(c);
                escape = false;
                continue;
            }
            switch (c) {
                case '{': {
                    if (stackDepth == 0) {
                        argumentIndex = 0;
                        arguments[0] = null;
                        arguments[1] = null;
                        arguments[2] = null;
                        constants.add(b.toString());
                        this.sizeHint += b.length();
                        b.delete(0, b.length());
                    } else {
                        b.append('{');
                    }
                    ++stackDepth;
                    continue block8;
                }
                case '}': {
                    if (--stackDepth < 0) {
                        throw new IllegalArgumentException("Invalid pattern; curly braces do not match at position: " + i);
                    }
                    if (stackDepth == 0) {
                        arguments[argumentIndex] = b.toString();
                        b.delete(0, b.length());
                        String argIndexString = arguments[0];
                        if (argIndexString == null) {
                            throw new IllegalArgumentException("Invalid pattern; no argument index for pattern ending at: " + i);
                        }
                        try {
                            indexMappings.add(new Integer(argIndexString));
                            String argTypeRaw = arguments[1];
                            String argPattern = arguments[2];
                            patterns.add(this.createFormatter(locale, argTypeRaw, argPattern));
                            continue block8;
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("Invalid pattern; argument index is no number: " + i);
                        }
                    }
                    b.append('}');
                    continue block8;
                }
                case ',': {
                    if (stackDepth == 1 && argumentIndex < 2) {
                        arguments[argumentIndex] = b.toString();
                        b.delete(0, b.length());
                        ++argumentIndex;
                        continue block8;
                    }
                    b.append(c);
                    continue block8;
                }
                case '\\': {
                    escape = true;
                    continue block8;
                }
                default: {
                    b.append(c);
                }
            }
        }
        this.sizeHint += b.length();
        constants.add(b.toString());
        if (stackDepth != 0) {
            throw new IllegalArgumentException("Invalid pattern; curly braces do not match");
        }
        this.constantTexts = constants.toArray(new String[constants.size()]);
        this.argumentMapping = new int[indexMappings.size()];
        for (i = 0; i < indexMappings.size(); ++i) {
            Integer integer = (Integer)indexMappings.get(i);
            this.argumentMapping[i] = integer;
        }
        this.subFormats = patterns.toArray(new FastFormat[patterns.size()]);
        this.sizeHint += this.argumentMapping.length * 5;
    }

    private FastFormat createFormatter(Locale locale, String argTypeRaw, String argPattern) {
        if (argTypeRaw == null) {
            return null;
        }
        String trimmedType = argTypeRaw.trim();
        if ("time".equals(trimmedType)) {
            if ("short".equals(argPattern)) {
                return new FastDateFormat(0, 3, locale);
            }
            if ("medium".equals(argPattern)) {
                return new FastDateFormat(0, 2, locale);
            }
            if ("long".equals(argPattern)) {
                return new FastDateFormat(0, 1, locale);
            }
            if ("full".equals(argPattern)) {
                return new FastDateFormat(0, 0, locale);
            }
            if (argPattern == null) {
                return new FastDateFormat(0, 2, locale);
            }
            return new FastDateFormat(argPattern, locale);
        }
        if ("date".equals(trimmedType)) {
            if ("short".equals(argPattern)) {
                return new FastDateFormat(3, 0, locale);
            }
            if ("medium".equals(argPattern)) {
                return new FastDateFormat(2, 0, locale);
            }
            if ("long".equals(argPattern)) {
                return new FastDateFormat(1, 0, locale);
            }
            if ("full".equals(argPattern)) {
                return new FastDateFormat(0, 0, locale);
            }
            if (argPattern == null) {
                return new FastDateFormat(2, 0, locale);
            }
            return new FastDateFormat(argPattern, locale);
        }
        if ("datetime".equals(trimmedType)) {
            if ("short".equals(argPattern)) {
                return new FastDateFormat(3, 3, locale);
            }
            if ("medium".equals(argPattern)) {
                return new FastDateFormat(2, 2, locale);
            }
            if ("long".equals(argPattern)) {
                return new FastDateFormat(1, 1, locale);
            }
            if ("full".equals(argPattern)) {
                return new FastDateFormat(0, 0, locale);
            }
            if (argPattern == null) {
                return new FastDateFormat(0, 2, locale);
            }
            return new FastDateFormat(argPattern, locale);
        }
        if ("number".equals(trimmedType)) {
            if ("currency".equals(argPattern)) {
                return new FastDecimalFormat(2, locale);
            }
            if ("percent".equals(argPattern)) {
                return new FastDecimalFormat(3, locale);
            }
            if ("integer".equals(argPattern)) {
                return new FastDecimalFormat(1, locale);
            }
            if (argPattern == null) {
                return new FastDecimalFormat(0, locale);
            }
            return new FastDecimalFormat(argPattern, locale);
        }
        if ("choice".equals(trimmedType)) {
            return new FastChoiceFormat(argPattern, locale);
        }
        return null;
    }

    public int getSubFormatCount() {
        return this.subFormats.length;
    }

    protected FastFormat getSubFormat(int index) {
        FastFormat fastFormat = this.subFormats[index];
        if (fastFormat != null) {
            try {
                return (FastFormat)fastFormat.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected FastFormat[] getSubFormats() {
        try {
            FastFormat[] retval = new FastFormat[this.subFormats.length];
            for (int i = 0; i < this.subFormats.length; ++i) {
                FastFormat fastFormat = this.subFormats[i];
                if (fastFormat == null) continue;
                retval[i] = (FastFormat)fastFormat.clone();
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should not happen");
        }
    }

    protected void setSubFormats(FastFormat[] subFormats) {
        if (subFormats == null) {
            throw new NullPointerException();
        }
        if (subFormats.length != this.subFormats.length) {
            throw new IllegalArgumentException();
        }
        try {
            for (int i = 0; i < subFormats.length; ++i) {
                FastFormat fastFormat = subFormats[i];
                if (fastFormat == null) continue;
                this.subFormats[i] = (FastFormat)fastFormat.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should not happen");
        }
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        if (nullString == null) {
            throw new NullPointerException();
        }
        this.nullString = nullString;
    }

    @Override
    public String format(Object parameters) {
        if (!(parameters instanceof Object[])) {
            throw new IllegalArgumentException();
        }
        Object[] parameterArray = (Object[])parameters;
        if (this.subFormats.length == 0) {
            return this.constantTexts[0];
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer(this.sizeHint);
        } else {
            this.buffer.delete(0, this.buffer.length());
        }
        for (int i = 0; i < this.subFormats.length; ++i) {
            FastFormat format = this.subFormats[i];
            this.buffer.append(this.constantTexts[i]);
            Object value = parameterArray[this.argumentMapping[i]];
            if (value == null) {
                this.buffer.append(this.nullString);
                continue;
            }
            if (format == null) {
                this.buffer.append(String.valueOf(value));
                continue;
            }
            if (format instanceof FastChoiceFormat) {
                String formatStr = format.format(value);
                FastMessageFormat fastMessageFormat = new FastMessageFormat(formatStr, this.locale);
                this.buffer.append(fastMessageFormat.format(parameters));
                continue;
            }
            this.buffer.append(format.format(value));
        }
        this.buffer.append(this.constantTexts[this.subFormats.length]);
        if (this.buffer.length() > this.sizeHint) {
            this.sizeHint = this.buffer.length();
        }
        return this.buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

