/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;
import org.pentaho.metastore.stores.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMetaStoreElementOwner
implements IMetaStoreElementOwner {
    private String name;
    private MetaStoreElementOwnerType type;

    public XmlMetaStoreElementOwner(String name, MetaStoreElementOwnerType type) {
        this.name = name;
        this.type = type;
    }

    public XmlMetaStoreElementOwner(Node elementNode) throws MetaStoreException {
        NodeList ownerNodes = elementNode.getChildNodes();
        for (int o = 0; o < ownerNodes.getLength(); ++o) {
            Node ownerNode = ownerNodes.item(o);
            if ("name".equals(ownerNode.getNodeName())) {
                this.name = XmlUtil.getNodeValue(ownerNode);
            }
            if (!"type".equals(ownerNode.getNodeName())) continue;
            String typeString = XmlUtil.getNodeValue(ownerNode);
            try {
                this.type = MetaStoreElementOwnerType.getOwnerType(typeString);
                continue;
            }
            catch (Exception ex) {
                throw new MetaStoreException("Unable to convert owner type [" + typeString + "] to one of USER, ROLE or SYSTEM_ROLE", ex);
            }
        }
    }

    public XmlMetaStoreElementOwner(IMetaStoreElementOwner owner) {
        this.name = owner.getName();
        this.type = owner.getOwnerType();
    }

    public void append(Document doc, Element ownerElement) {
        Element nameElement = doc.createElement("name");
        nameElement.appendChild(doc.createTextNode(this.name == null ? "" : this.name));
        ownerElement.appendChild(nameElement);
        Element typeElement = doc.createElement("type");
        typeElement.appendChild(doc.createTextNode(this.type == null ? "" : this.type.name()));
        ownerElement.appendChild(typeElement);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public MetaStoreElementOwnerType getOwnerType() {
        return this.type;
    }

    @Override
    public void setOwnerType(MetaStoreElementOwnerType type) {
        this.type = type;
    }
}

