/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DirectMemoryUtils {
    private static final Log LOG = LogFactory.getLog(DirectMemoryUtils.class);
    private static final MBeanServer beanServer;
    private static final ObjectName nioDirectPool;

    public static long getDirectMemorySize() {
        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimemxBean.getInputArguments();
        long multiplier = 1L;
        for (String s : arguments) {
            if (!s.contains("-XX:MaxDirectMemorySize=")) continue;
            String memSize = s.toLowerCase().replace("-xx:maxdirectmemorysize=", "").trim();
            if (memSize.contains("k")) {
                multiplier = 1024L;
            } else if (memSize.contains("m")) {
                multiplier = 0x100000L;
            } else if (memSize.contains("g")) {
                multiplier = 0x40000000L;
            }
            memSize = memSize.replaceAll("[^\\d]", "");
            long retValue = Long.parseLong(memSize);
            return retValue * multiplier;
        }
        return 0L;
    }

    public static long getDirectMemoryUsage() {
        if (beanServer == null || nioDirectPool == null) {
            return 0L;
        }
        try {
            Long value = (Long)beanServer.getAttribute(nioDirectPool, "MemoryUsed");
            return value == null ? 0L : value;
        }
        catch (JMException e) {
            LOG.debug((Object)"Failed to retrieve nio.BufferPool direct MemoryUsed");
            return 0L;
        }
    }

    public static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Preconditions.checkArgument((boolean)toBeDestroyed.isDirect(), (Object)"toBeDestroyed isn't direct!");
        Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.setAccessible(true);
        cleanMethod.invoke(cleaner, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ObjectName n = null;
        MBeanServer s = null;
        try {
            n = new ObjectName("java.nio:type=BufferPool,name=direct");
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)"Unable to initialize ObjectName for DirectByteBuffer allocations.");
        }
        finally {
            nioDirectPool = n;
        }
        if (nioDirectPool != null) {
            s = ManagementFactory.getPlatformMBeanServer();
        }
        beanServer = s;
    }
}

