/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.MetaMutationAnnotation;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public class RegionServerCoprocessorHost
extends CoprocessorHost<RegionServerEnvironment> {
    private RegionServerServices rsServices;

    public RegionServerCoprocessorHost(RegionServerServices rsServices, Configuration conf) {
        super((Abortable)rsServices);
        this.rsServices = rsServices;
        this.conf = conf;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.regionserver.classes");
    }

    @Override
    public RegionServerEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int sequence, Configuration conf) {
        return new RegionServerEnvironment(implClass, instance, priority, sequence, conf, this.rsServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preStop(String message) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).preStopRegionServer(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preMerge(HRegion regionA, HRegion regionB) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).preMerge(ctx, regionA, regionB);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMerge(HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).postMerge(ctx, regionA, regionB, mergedRegion);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preMergeCommit(HRegion regionA, HRegion regionB, @MetaMutationAnnotation List<Mutation> metaEntries) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).preMergeCommit(ctx, regionA, regionB, metaEntries);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMergeCommit(HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).postMergeCommit(ctx, regionA, regionB, mergedRegion);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollBackMerge(HRegion regionA, HRegion regionB) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).preRollBackMerge(ctx, regionA, regionB);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollBackMerge(HRegion regionA, HRegion regionB) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionServerObserver)env.getInstance()).postRollBackMerge(ctx, regionA, regionB);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }

    static class RegionServerEnvironment
    extends CoprocessorHost.Environment
    implements RegionServerCoprocessorEnvironment {
        private RegionServerServices regionServerServices;

        public RegionServerEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf);
            this.regionServerServices = services;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.regionServerServices;
        }
    }
}

