/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.concur.resource.OAdaptiveLock;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynch;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class OChannelBinaryClient
extends OChannelBinaryAsynch {
    protected final int socketTimeout;
    private final short srvProtocolVersion;
    private OAsynchChannelServiceThread serviceThread;

    public OChannelBinaryClient(String remoteHost, int remotePort, OContextConfiguration iConfig, int iProtocolVersion) throws IOException {
        this(remoteHost, remotePort, iConfig, iProtocolVersion, null);
    }

    public OChannelBinaryClient(String remoteHost, int remotePort, OContextConfiguration iConfig, int iProtocolVersion, ORemoteServerEventListener asynchEventListener) throws IOException {
        super(new Socket(), iConfig);
        this.socketTimeout = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.socket.setPerformancePreferences(0, 2, 1);
        this.socket.setKeepAlive(true);
        this.socket.setSendBufferSize(this.socketBufferSize);
        this.socket.setReceiveBufferSize(this.socketBufferSize);
        try {
            this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.socketTimeout);
            this.connected();
        }
        catch (SocketTimeoutException e) {
            throw new IOException("Cannot connect to host " + remoteHost + ":" + remotePort, e);
        }
        this.inStream = new BufferedInputStream(this.socket.getInputStream(), this.socketBufferSize);
        this.outStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socketBufferSize);
        this.in = new DataInputStream(this.inStream);
        this.out = new DataOutputStream(this.outStream);
        try {
            this.srvProtocolVersion = this.readShort();
        }
        catch (IOException e) {
            throw new ONetworkProtocolException("Cannot read protocol version from remote server " + this.socket.getRemoteSocketAddress() + ": " + e);
        }
        if (this.srvProtocolVersion != iProtocolVersion) {
            OLogManager.instance().warn((Object)this, "The Client driver version is different than Server version: client=" + iProtocolVersion + ", server=" + this.srvProtocolVersion + ". You could not use the full features of the newer version. Assure to have the same versions on both", new Object[0]);
        }
        if (asynchEventListener != null) {
            this.serviceThread = new OAsynchChannelServiceThread(asynchEventListener, this);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.serviceThread != null) {
            OAsynchChannelServiceThread s = this.serviceThread;
            this.serviceThread = null;
            s.sendShutdown();
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public short getSrvProtocolVersion() {
        return this.srvProtocolVersion;
    }

    public OAdaptiveLock getLockRead() {
        return this.lockRead;
    }

    public OAdaptiveLock getLockWrite() {
        return this.lockWrite;
    }
}

