/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.version.ODistributedVersion;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class OChannelBinary
extends OChannel {
    private static final int MAX_LENGTH_DEBUG = 150;
    public DataInputStream in;
    public DataOutputStream out;
    private final int maxChunkSize;
    protected final boolean debug;
    private final byte[] buffer;

    public OChannelBinary(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
        this.maxChunkSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH);
        this.debug = iConfig.getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DEBUG);
        this.buffer = new byte[this.maxChunkSize];
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Connected", new Object[]{this.socket.getRemoteSocketAddress()});
        }
    }

    public byte readByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading byte (1 byte)...", new Object[]{this.socket.getRemoteSocketAddress()});
            byte value = this.in.readByte();
            OLogManager.instance().info((Object)this, "%s - Read byte: %d", new Object[]{this.socket.getRemoteSocketAddress(), (int)value});
            return value;
        }
        return this.in.readByte();
    }

    public int readInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            int value = this.in.readInt();
            OLogManager.instance().info((Object)this, "%s - Read int: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.updateMetricReceivedBytes(8);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading long (8 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            long value = this.in.readLong();
            OLogManager.instance().info((Object)this, "%s - Read long: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading short (2 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            short value = this.in.readShort();
            OLogManager.instance().info((Object)this, "%s - Read short: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readShort();
    }

    public String readString() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading string (4+N bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            int len = this.in.readInt();
            if (len < 0) {
                return null;
            }
            byte[] tmp = new byte[len];
            this.in.readFully(tmp);
            this.updateMetricReceivedBytes(4 + len);
            String value = new String(tmp);
            OLogManager.instance().info((Object)this, "%s - Read string: %s", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        int len = this.in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        this.updateMetricReceivedBytes(4 + len);
        return new String(tmp);
    }

    public byte[] readBytes() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading chunk of bytes. Reading chunk length as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int len = this.in.readInt();
        this.updateMetricReceivedBytes(4 + len);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read chunk lenght: %d", new Object[]{this.socket.getRemoteSocketAddress(), len});
        }
        if (len < 0) {
            return null;
        }
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading %d bytes...", new Object[]{this.socket.getRemoteSocketAddress(), len});
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read %d bytes: %s", new Object[]{this.socket.getRemoteSocketAddress(), len, new String(tmp)});
        }
        return tmp;
    }

    public List<String> readStringList() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading string list. Reading string list items as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int items = this.in.readInt();
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read string list items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        if (items < 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < items; ++i) {
            result.add(this.readString());
        }
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read string list with %d items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        return result;
    }

    public Set<String> readStringSet() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading string set. Reading string set items as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int items = this.in.readInt();
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read string set items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        if (items < 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < items; ++i) {
            result.add(this.readString());
        }
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read string set with %d items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items, result});
        }
        return result;
    }

    public ORecordId readRID() throws IOException {
        short clusterId = this.readShort();
        OClusterPosition clusterPosition = this.readClusterPosition();
        return new ORecordId((int)clusterId, clusterPosition);
    }

    public OClusterPosition readClusterPosition() throws IOException {
        int serializedSize = OClusterPositionFactory.INSTANCE.getSerializedSize();
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading cluster position (%d bytes)....", new Object[]{this.socket.getRemoteSocketAddress(), serializedSize});
        }
        OClusterPosition clusterPosition = OClusterPositionFactory.INSTANCE.fromStream((InputStream)this.in);
        this.updateMetricReceivedBytes(serializedSize);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read cluster position: %s", new Object[]{this.socket.getRemoteSocketAddress(), clusterPosition});
        }
        return clusterPosition;
    }

    public OChannelBinary writeClusterPosition(OClusterPosition clusterPosition) throws IOException {
        int serializedSize = OClusterPositionFactory.INSTANCE.getSerializedSize();
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing cluster position (%d bytes) : %s....", new Object[]{this.socket.getRemoteSocketAddress(), serializedSize, clusterPosition});
        }
        this.out.write(clusterPosition.toStream());
        this.updateMetricTransmittedBytes(serializedSize);
        return this;
    }

    public ORecordVersion readVersion() throws IOException {
        if (OVersionFactory.instance().isDistributed()) {
            int recordVersion = this.readInt();
            long timestamp = this.readLong();
            long macAddress = this.readLong();
            return OVersionFactory.instance().createDistributedVersion(recordVersion, timestamp, macAddress);
        }
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.setCounter(this.readInt());
        return version;
    }

    public OChannelBinary writeByte(byte iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing byte (1 byte): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.write(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    public OChannelBinary writeInt(int iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing int (4 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeInt(iContent);
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    public OChannelBinary writeLong(long iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing long (8 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeLong(iContent);
        this.updateMetricTransmittedBytes(8);
        return this;
    }

    public OChannelBinary writeShort(short iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing short (2 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeShort(iContent);
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    public OChannelBinary writeString(String iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing string (4+%d=%d bytes): %s", new Object[]{this.socket.getRemoteSocketAddress(), iContent != null ? iContent.length() : 0, iContent != null ? iContent.length() + 4 : 4, iContent});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            byte[] buffer = iContent.getBytes();
            this.out.writeInt(buffer.length);
            this.out.write(buffer, 0, buffer.length);
            this.updateMetricTransmittedBytes(4 + buffer.length);
        }
        return this;
    }

    public OChannelBinary writeBytes(byte[] iContent) throws IOException {
        return this.writeBytes(iContent, iContent != null ? iContent.length : 0);
    }

    public OChannelBinary writeBytes(byte[] iContent, int iLength) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing bytes (4+%d=%d bytes): %s", new Object[]{this.socket.getRemoteSocketAddress(), iLength, iLength + 4, Arrays.toString(iContent)});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
            this.updateMetricTransmittedBytes(4 + iLength);
        }
        return this;
    }

    public OChannelBinary writeCollectionString(Collection<String> iCollection) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing strings (4+%d=%d items): %s", new Object[]{this.socket.getRemoteSocketAddress(), iCollection != null ? iCollection.size() : 0, iCollection != null ? iCollection.size() + 4 : 4, iCollection.toString()});
        }
        this.updateMetricTransmittedBytes(4);
        if (iCollection == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(iCollection.size());
            for (String s : iCollection) {
                this.writeString(s);
            }
        }
        return this;
    }

    public void writeRID(ORID iRID) throws IOException {
        this.writeShort((short)iRID.getClusterId());
        this.writeClusterPosition(iRID.getClusterPosition());
    }

    public void writeVersion(ORecordVersion version) throws IOException {
        if (version instanceof ODistributedVersion) {
            ODistributedVersion v = (ODistributedVersion)version;
            this.writeInt(v.getCounter());
            this.writeLong(v.getTimestamp());
            this.writeLong(v.getMacAddress());
        } else {
            this.writeInt(version.getCounter());
        }
    }

    public void clearInput() throws IOException {
        if (this.in == null) {
            return;
        }
        StringBuilder dirtyBuffer = new StringBuilder(150);
        int i = 0;
        while (this.in.available() > 0) {
            char c = (char)this.in.read();
            ++i;
            if (dirtyBuffer.length() >= 150) continue;
            dirtyBuffer.append(c);
        }
        this.updateMetricReceivedBytes(i);
        OLogManager.instance().error((Object)this, "Received unread response from " + this.socket.getRemoteSocketAddress() + " probably corrupted data from the network connection. Cleared dirty data in the buffer (" + i + " bytes): [" + dirtyBuffer + (i > dirtyBuffer.length() ? "..." : "") + "]", OIOException.class);
    }

    @Override
    public void flush() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Flush", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        this.updateMetricFlushes();
        super.flush();
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Closing socket...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    public int readStatus() throws IOException {
        return this.handleStatus(this.readByte(), this.readInt());
    }

    protected int handleStatus(byte iResult, int iClientTxId) throws IOException {
        if (iResult != 0 && iResult != 3) {
            if (iResult == 1) {
                StringBuilder buffer = new StringBuilder();
                ArrayList<OPair> exceptions = new ArrayList<OPair>();
                while (this.readByte() == 1) {
                    String excClassName = this.readString();
                    String excMessage = this.readString();
                    exceptions.add(new OPair((Comparable)((Object)excClassName), (Object)excMessage));
                }
                RuntimeException previous = null;
                for (int i = exceptions.size() - 1; i > -1; --i) {
                    previous = OChannelBinary.createException((String)((Object)((OPair)exceptions.get(i)).getKey()), (String)((OPair)exceptions.get(i)).getValue(), previous);
                }
                if (previous != null) {
                    if (previous instanceof RuntimeException) {
                        throw (RuntimeException)previous;
                    }
                    throw new ODatabaseException("Generic error, see the underlying cause", previous);
                }
                throw new ONetworkProtocolException("Network response error: " + buffer.toString());
            }
            throw new ONetworkProtocolException("Error on reading response from the server");
        }
        return iClientTxId;
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        Object rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = new OStorageException(iMessage, (Throwable)iPrevious);
        }
        if (c != null) {
            try {
                e = c.getParameterTypes().length > 1 ? (Exception)c.newInstance(iMessage, iPrevious) : (Exception)c.newInstance(iMessage);
                rootException = e instanceof RuntimeException ? (RuntimeException)e : new OException((Throwable)e);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return rootException;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }
}

