/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;

public class HttpMimeTypeListener
implements IMimeTypeListener {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private String title;

    public HttpMimeTypeListener(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, null);
    }

    public HttpMimeTypeListener(HttpServletRequest request, HttpServletResponse response, String title) {
        this.request = request;
        this.response = response;
        this.title = title;
    }

    public void setName(String name) {
        this.title = name;
    }

    public void setMimeType(String mimeType) {
        this.response.setContentType(mimeType);
        this.response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
        String forceAttachment = this.request.getParameter("forceAttachment");
        String fileName = this.title;
        if (fileName == null) {
            fileName = "default";
        }
        fileName = fileName.replace(' ', '_');
        fileName = fileName + MimeHelper.getExtension((String)mimeType);
        if (forceAttachment != null && "true".equalsIgnoreCase(forceAttachment)) {
            this.response.setHeader("content-disposition", "attachment;filename=" + fileName);
        } else {
            this.response.setHeader("content-disposition", "inline;filename=" + fileName);
        }
    }
}

