/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.security.ui.basicauth.BasicProcessingFilter;

public class PentahoBasicProcessingFilter
extends BasicProcessingFilter
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid()) {
            String header;
            Cookie expiredCookie = null;
            for (Cookie c : request.getCookies()) {
                if (!"JSESSIONID".equals(c.getName())) continue;
                expiredCookie = c;
                break;
            }
            if ((header = request.getHeader("Authorization")) != null && header.indexOf("Basic") == 0) {
                for (Cookie c : request.getCookies()) {
                    if (!"session-flushed".equals(c.getName())) continue;
                    c.setMaxAge(0);
                    response.addCookie(c);
                    break;
                }
                this.getAuthenticationEntryPoint().commence((ServletRequest)request, (ServletResponse)response, (AuthenticationException)new BadCredentialsException("Clearing Basic-Auth"));
                return;
            }
            if (expiredCookie != null) {
                Cookie c = new Cookie("session-flushed", "true");
                c.setPath(request.getContextPath() != null ? request.getContextPath() : "/");
                c.setMaxAge(-1);
                response.addCookie(c);
            }
        } else {
            Cookie[] cookies;
            String header = request.getHeader("Authorization");
            if (header != null && header.indexOf("Basic") == 0 && SecurityContextHolder.getContext().getAuthentication() == null && (cookies = request.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!"session-flushed".equals(c.getName())) continue;
                    c.setMaxAge(0);
                    c.setPath(request.getContextPath() != null ? request.getContextPath() : "/");
                    response.addCookie(c);
                    this.getAuthenticationEntryPoint().commence((ServletRequest)request, (ServletResponse)response, (AuthenticationException)new BadCredentialsException("Clearing Basic-Auth"));
                    return;
                }
            }
        }
        super.doFilterHttp(request, response, chain);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        super.onSuccessfulAuthentication(request, response, authResult);
        request.getSession().setAttribute("BasicAuth", (Object)"true");
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authResult));
        }
    }
}

