/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.services.SessionService;

@Path(value="/session/")
public class SessionResource
extends AbstractJaxRSResource {
    private static SessionService sessionService;

    public SessionResource() {
        sessionService = new SessionService();
    }

    @GET
    @Path(value="/userWorkspaceDir")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns the requested file path")})
    public String doGetCurrentUserDir() {
        return this.getUserHomeFolderPath(this.getSession().getName()) + "/workspace";
    }

    @GET
    @Path(value="/workspaceDirForUser/{user}")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns the workspace file path for the specified user."), @ResponseCode(code=500, condition="File path failed to be retrieved. This could be caused by an invalid user request.")})
    public String doGetUserDir(@PathParam(value="user") String user) {
        return this.getUserHomeFolderPath(user) + "/workspace";
    }

    @GET
    @Path(value="/setredirect")
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response setredirect() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        pentahoSession.setAttribute("redirect", (Object)true);
        return Response.ok().type("text/plain").build();
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected String getUserHomeFolderPath(String username) {
        return ClientRepositoryPaths.getUserHomeFolderPath((String)username);
    }
}

