/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.services.FileService;

@Path(value="/repo/dirs/")
public class DirectoryResource
extends AbstractJaxRSResource {
    protected FileService fileService = new FileService();
    private static final Log logger = LogFactory.getLog(FileResource.class);

    public DirectoryResource() {
    }

    public DirectoryResource(HttpServletResponse httpServletResponse) {
        this();
        this.httpServletResponse = httpServletResponse;
    }

    @PUT
    @Path(value="{pathId : .+}")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created folder."), @ResponseCode(code=409, condition="Path already exists."), @ResponseCode(code=500, condition="Server Error.")})
    public Response createDirs(@PathParam(value="pathId") String pathId) {
        try {
            if (this.fileService.doCreateDir(pathId)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"couldNotCreateFolderDuplicate").build();
        }
        catch (Throwable t) {
            return Response.serverError().entity((Object)t.getMessage()).build();
        }
    }
}

